/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.util.Comparator;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassExpressionComparator
implements Comparator<OWLClassExpression> {
    private TypeVisitor typeVisitor;
    private OWLModelManager owlModelManager;
    private OWLClassExpression focusedDescription;

    public OWLClassExpressionComparator(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        this.typeVisitor = new TypeVisitor();
    }

    public OWLClassExpression getFocusedDescription() {
        return this.focusedDescription;
    }

    public void setFocusedDescription(OWLClassExpression focusedDescription) {
        this.focusedDescription = focusedDescription;
    }

    @Override
    public int compare(OWLClassExpression o1, OWLClassExpression o2) {
        if (this.focusedDescription != null) {
            if (o1.equals(this.focusedDescription)) {
                return -1;
            }
            if (o2.equals(this.focusedDescription)) {
                return 1;
            }
        }
        o1.accept((OWLClassExpressionVisitor)this.typeVisitor);
        int type1 = this.typeVisitor.getType();
        o2.accept((OWLClassExpressionVisitor)this.typeVisitor);
        int type2 = this.typeVisitor.getType();
        int diff = type1 - type2;
        if (diff != 0) {
            return diff;
        }
        if (this.owlModelManager != null) {
            return this.owlModelManager.getRendering((OWLObject)o1).compareToIgnoreCase(this.owlModelManager.getRendering((OWLObject)o2));
        }
        return -1;
    }

    private class TypeVisitor
    implements OWLClassExpressionVisitor {
        private int type;

        private TypeVisitor() {
        }

        public int getType() {
            return this.type;
        }

        public void visit(OWLClass owlClass) {
            this.type = 1000;
        }

        public void visit(OWLObjectIntersectionOf owlAnd) {
            this.type = 2000;
        }

        public void visit(OWLObjectComplementOf owlNot) {
            this.type = 2001;
        }

        public void visit(OWLObjectUnionOf owlOr) {
            this.type = 2002;
        }

        public void visit(OWLObjectSomeValuesFrom owlObjectSomeValuesFrom) {
            this.type = 3001;
        }

        public void visit(OWLObjectHasValue owlObjectValueRestriction) {
            this.type = 3002;
        }

        public void visit(OWLObjectAllValuesFrom owlObjectAllRestriction) {
            this.type = 3003;
        }

        public void visit(OWLDataSomeValuesFrom owlDataSomeValuesFrom) {
            this.type = 3004;
        }

        public void visit(OWLDataHasValue owlDataValueRestriction) {
            this.type = 3005;
        }

        public void visit(OWLDataAllValuesFrom owlDataAllRestriction) {
            this.type = 3006;
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.type = 3010;
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.type = 3011;
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.type = 3012;
        }

        public void visit(OWLDataMinCardinality desc) {
            this.type = 3007;
        }

        public void visit(OWLDataExactCardinality desc) {
            this.type = 3008;
        }

        public void visit(OWLDataMaxCardinality desc) {
            this.type = 3009;
        }

        public void visit(OWLObjectOneOf owlEnumeration) {
            this.type = 4000;
        }

        public void visit(OWLObjectHasSelf desc) {
            this.type = 6000;
        }
    }
}

