/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.model.entity.CustomOWLEntityFactory;
import org.protege.editor.owl.model.entity.OWLEntityCreationException;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditorPreferences;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLAutoCompleter;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityCreationPanel<T extends OWLEntity>
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = -2790553738912229896L;
    private final int INTERNAL_PADDING = 5;
    private OWLEditorKit owlEditorKit;
    private JTextField textField;
    private JCheckBox useRawUri;
    private JLabel errorLabel;
    private final Icon warningIcon = Icons.getIcon((String)"warning.png");
    private Class<T> type;
    private List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();
    private boolean currentlyValid = true;
    private Timer timer = new Timer(ExpressionEditorPreferences.getInstance().getCheckDelay(), new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            OWLEntityCreationPanel.this.performCheck();
            OWLEntityCreationPanel.this.timer.stop();
        }
    });
    private JLabel uriPreviewLabel;

    public OWLEntityCreationPanel(OWLEditorKit owlEditorKit, String message, Class<T> type) {
        this.owlEditorKit = owlEditorKit;
        this.type = type;
        this.createUI(message);
    }

    @Override
    public void setEnabled(boolean b) {
        this.textField.setEnabled(b);
        super.setEnabled(b);
    }

    @Override
    public void setName(String name) {
        this.textField.setText(name);
    }

    private void createUI(String message) {
        this.setLayout(new BorderLayout());
        JPanel entryPanel = new JPanel();
        entryPanel.setLayout(new BoxLayout(entryPanel, 1));
        this.textField = new JTextField(30);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                OWLEntityCreationPanel.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                OWLEntityCreationPanel.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                OWLEntityCreationPanel.this.update();
            }
        });
        if (message != null) {
            JLabel label = new JLabel(message);
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            entryPanel.add(label);
        }
        entryPanel.add(this.textField);
        this.useRawUri = new JCheckBox("Ignore entity creation preferences");
        this.useRawUri.setSelected(false);
        this.useRawUri.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.useRawUri.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OWLEntityCreationPanel.this.update();
            }
        });
        entryPanel.add(this.useRawUri);
        this.errorLabel = new JLabel("");
        this.errorLabel.setFont(this.errorLabel.getFont().deriveFont(10.0f));
        this.errorLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.errorLabel.setPreferredSize(new Dimension(this.errorLabel.getPreferredSize().width, 40));
        this.uriPreviewLabel = new JLabel("");
        this.uriPreviewLabel.setFont(this.errorLabel.getFont().deriveFont(10.0f));
        this.uriPreviewLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box previewPanel = new Box(3);
        previewPanel.add(this.uriPreviewLabel);
        this.add((Component)entryPanel, "North");
        this.add((Component)previewPanel, "Center");
        this.add((Component)this.errorLabel, "South");
        OWLAutoCompleter completer = new OWLAutoCompleter(this.owlEditorKit, this.textField, new OWLExpressionChecker(){

            public void check(String text) throws OWLExpressionParserException {
                throw new OWLExpressionParserException(text, 0, text.length(), OWLClass.class.isAssignableFrom(OWLEntityCreationPanel.this.type), OWLObjectProperty.class.isAssignableFrom(OWLEntityCreationPanel.this.type), OWLDataProperty.class.isAssignableFrom(OWLEntityCreationPanel.this.type), OWLIndividual.class.isAssignableFrom(OWLEntityCreationPanel.this.type), OWLDatatype.class.isAssignableFrom(OWLEntityCreationPanel.this.type), OWLAnnotationProperty.class.isAssignableFrom(OWLEntityCreationPanel.this.type), new HashSet<String>());
            }

            public Object createObject(String text) throws OWLExpressionParserException {
                return null;
            }
        });
    }

    public String getEntityName() {
        return this.textField.getText();
    }

    public OWLEntityCreationSet<T> getOWLEntityCreationSet() {
        try {
            if (this.useRawIri()) {
                IRI iri = this.getRawIRI();
                OWLOntology ontology = this.owlEditorKit.getModelManager().getActiveOntology();
                OWLDataFactory factory = this.owlEditorKit.getModelManager().getOWLDataFactory();
                T owlEntity = CustomOWLEntityFactory.getOWLEntity(factory, this.type, iri);
                AddAxiom addDecl = new AddAxiom(ontology, (OWLAxiom)factory.getOWLDeclarationAxiom(owlEntity));
                return new OWLEntityCreationSet<T>(owlEntity, Collections.singletonList(addDecl));
            }
            return this.owlEditorKit.getModelManager().getOWLEntityFactory().createOWLEntity(this.type, this.getEntityName(), this.getBaseIRI());
        }
        catch (OWLEntityCreationException e) {
            return null;
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        this.performCheck();
        listener.verifiedStatusChanged(this.currentlyValid);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public static <T extends OWLEntity> OWLEntityCreationSet<T> showDialog(OWLEditorKit owlEditorKit, String message, Class<T> type) {
        OWLEntityCreationPanel<T> panel = new OWLEntityCreationPanel<T>(owlEditorKit, message, type);
        int ret = new UIHelper(owlEditorKit).showValidatingDialog("Create a new " + type.getSimpleName(), panel, panel.textField);
        if (ret == 0) {
            return panel.getOWLEntityCreationSet();
        }
        return null;
    }

    public IRI getBaseIRI() {
        return null;
    }

    private void update() {
        this.currentlyValid = false;
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(this.currentlyValid);
        }
        this.timer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCheck() {
        block12: {
            boolean wasValid = this.currentlyValid;
            try {
                IRI iri;
                String name = this.getEntityName();
                if (this.useRawIri()) {
                    iri = this.getRawIRI();
                } else {
                    OWLEntityCreationSet<T> changeSet = this.owlEditorKit.getModelManager().getOWLEntityFactory().preview(this.type, name, this.getBaseIRI());
                    iri = changeSet.getOWLEntity().getIRI();
                }
                this.uriPreviewLabel.setText(iri.toString());
                this.currentlyValid = true;
                String warningMessage = null;
                for (OWLOntology ont : this.owlEditorKit.getOWLModelManager().getActiveOntologies()) {
                    if (!ont.containsEntityInSignature(iri)) continue;
                    warningMessage = "Warning: this name is already being used for a different type of entity.";
                    break;
                }
                if (warningMessage == null) {
                    OWLEntity entity = this.owlEditorKit.getModelManager().getOWLEntityFinder().getOWLEntity(name);
                    if (entity != null) {
                        warningMessage = "Warning: an entity with that name already exists.";
                    } else {
                        this.clearMessage();
                    }
                }
                if (warningMessage == null) break block12;
                this.displayWarningMessage(warningMessage);
            }
            catch (OWLEntityCreationException e) {
                this.currentlyValid = false;
                this.handleException(e);
            }
            finally {
                if (wasValid == this.currentlyValid) break block12;
                for (InputVerificationStatusChangedListener l : this.listeners) {
                    l.verifiedStatusChanged(this.currentlyValid);
                }
            }
        }
    }

    private void handleException(OWLEntityCreationException e) {
        boolean handled = false;
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof URISyntaxException) {
            this.handleURISyntaxException((URISyntaxException)cause);
            handled = true;
        }
        if (!handled) {
            this.displayWarningMessage("Error: " + e.getMessage());
        }
    }

    private void handleURISyntaxException(URISyntaxException e) {
        int actualIndex = e.getIndex();
        String fullURI = e.getInput();
        int indexFromRHS = fullURI.length() - actualIndex;
        int relativeIndex = this.getEntityName().length() - indexFromRHS;
        this.textField.setSelectionStart(relativeIndex);
        this.textField.setSelectionEnd(this.getEntityName().length());
        this.displayWarningMessage("Invalid name: " + e.getReason());
    }

    private void displayWarningMessage(String message) {
        this.errorLabel.setIcon(this.warningIcon);
        this.errorLabel.setText("<html>" + message + "</html>");
        this.errorLabel.validate();
    }

    private void clearMessage() {
        this.errorLabel.setIcon(null);
        this.errorLabel.setText("");
        this.errorLabel.validate();
    }

    private boolean useRawIri() {
        return this.useRawUri.isSelected();
    }

    private IRI getRawIRI() {
        String prefixName;
        PrefixOWLOntologyFormat prefixes;
        String prefix;
        String text = this.textField.getText();
        OWLOntology activeOntology = this.owlEditorKit.getModelManager().getActiveOntology();
        OWLOntologyManager manager = this.owlEditorKit.getModelManager().getOWLOntologyManager();
        OWLOntologyFormat format = manager.getOntologyFormat(activeOntology);
        int colonIndex = text.indexOf(58);
        if (colonIndex >= 0 && format.isPrefixOWLOntologyFormat() && (prefix = (prefixes = format.asPrefixOWLOntologyFormat()).getPrefix(prefixName = text.substring(0, colonIndex + 1))) != null) {
            return IRI.create((String)(prefix + text.substring(colonIndex + 1)));
        }
        return IRI.create((String)text);
    }

    public JComponent getFocusComponent() {
        return this.textField;
    }
}

