/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import javax.swing.JComponent;
import org.protege.editor.core.ProtegeProperties;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.workspace.WorkspaceViewsTab;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLEntityDisplayProvider;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.view.AbstractOWLSelectionViewComponent;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLWorkspaceViewsTab
extends WorkspaceViewsTab {
    private static final long serialVersionUID = 2800648962536275497L;
    private OWLEntityDisplayProvider provider = new OWLEntityDisplayProvider(){

        public boolean canDisplay(OWLEntity owlEntity) {
            return OWLWorkspaceViewsTab.this.canDisplay(owlEntity);
        }

        public JComponent getDisplayComponent() {
            return OWLWorkspaceViewsTab.this;
        }
    };

    private boolean canDisplay(OWLEntity owlEntity) {
        String entityCat = new NavFinder().getNav(owlEntity);
        for (View view : this.getViewsPane().getViews()) {
            ViewComponent vc = view.getViewComponent();
            if (vc != null) {
                AbstractOWLSelectionViewComponent owlEntityViewComponent;
                if (!(vc instanceof AbstractOWLSelectionViewComponent) || !(owlEntityViewComponent = (AbstractOWLSelectionViewComponent)vc).canShowEntity(owlEntity)) continue;
                return true;
            }
            ViewComponentPlugin plugin = this.getWorkspace().getViewManager().getViewComponentPlugin(view.getId());
            if (plugin == null) continue;
            for (String nav : plugin.getNavigates()) {
                if (!entityCat.equals(nav)) continue;
                return true;
            }
        }
        return false;
    }

    public void initialise() {
        super.initialise();
        this.getOWLEditorKit().getWorkspace().registerOWLEntityDisplayProvider(this.provider);
    }

    public void dispose() {
        this.getOWLEditorKit().getWorkspace().unregisterOWLEntityDisplayProvider(this.provider);
        super.dispose();
    }

    public OWLModelManager getOWLModelManager() {
        return (OWLModelManager)this.getWorkspace().getEditorKit().getModelManager();
    }

    public OWLEditorKit getOWLEditorKit() {
        return (OWLEditorKit)this.getWorkspace().getEditorKit();
    }

    class NavFinder
    implements OWLEntityVisitor {
        private String nav;

        NavFinder() {
        }

        public String getNav(OWLEntity owlEntity) {
            this.nav = null;
            owlEntity.accept((OWLEntityVisitor)this);
            return this.nav;
        }

        public void visit(OWLClass owlClass) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.classcategory");
        }

        public void visit(OWLObjectProperty owlObjectProperty) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.objectpropertycategory");
        }

        public void visit(OWLDataProperty owlDataProperty) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.datapropertycategory");
        }

        public void visit(OWLAnnotationProperty owlAnnotationProperty) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.annotationpropertycategory");
        }

        public void visit(OWLNamedIndividual owlIndividual) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.individualcategory");
        }

        public void visit(OWLDatatype owlDatatype) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.datatypecategory");
        }
    }
}

