/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.hierarchy.OWLOntologyHierarchyProvider;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class OntologyImportsAndNavigationPanel
extends JPanel {
    private static final long serialVersionUID = 7247887353859536512L;
    private OWLEditorKit owlEditorKit;
    private OWLModelManagerTree<OWLOntology> tree;
    private JCheckBox showImportsCheckBox;

    public OntologyImportsAndNavigationPanel(OWLEditorKit editorKit) {
        this.owlEditorKit = editorKit;
        this.setLayout(new BorderLayout());
        this.tree = new OWLModelManagerTree<OWLOntology>(this.owlEditorKit, new OWLOntologyHierarchyProvider(this.owlEditorKit.getModelManager()));
        this.add(new JScrollPane(this.tree));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                OWLOntology ont = (OWLOntology)OntologyImportsAndNavigationPanel.this.tree.getSelectedOWLObject();
                if (ont != null) {
                    OntologyImportsAndNavigationPanel.this.owlEditorKit.getModelManager().setActiveOntology(ont);
                    OntologyImportsAndNavigationPanel.this.owlEditorKit.getWorkspace().getOWLSelectionModel().setSelectedObject((OWLObject)ont);
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                OWLOntology ont = (OWLOntology)OntologyImportsAndNavigationPanel.this.tree.getSelectedOWLObject();
                if (ont != null) {
                    OntologyImportsAndNavigationPanel.this.owlEditorKit.getWorkspace().getOWLSelectionModel().setSelectedObject(null);
                    OntologyImportsAndNavigationPanel.this.owlEditorKit.getWorkspace().getOWLSelectionModel().setSelectedObject((OWLObject)ont);
                }
            }
        });
        this.showImportsCheckBox = new JCheckBox(new AbstractAction("Show imported axioms"){
            private static final long serialVersionUID = -1171161540845340564L;

            public void actionPerformed(ActionEvent e) {
                OntologyImportsAndNavigationPanel.this.setShowImports();
            }
        });
        this.showImportsCheckBox.setFont(this.showImportsCheckBox.getFont().deriveFont(0, 11.0f));
        this.add((Component)this.showImportsCheckBox, "South");
        this.tree.setCellRenderer(new OntologyTreeCellRenderer());
    }

    private void setShowImports() {
    }

    private class OntologyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -5285478535989683861L;

        private OntologyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            OWLOntology ontology = (OWLOntology)((OWLObjectTreeNode)value).getOWLObject();
            if (ontology == null) {
                return label;
            }
            String uriString = ontology.getOntologyID().toString();
            int lastSepIndex = uriString.lastIndexOf(47);
            StringBuilder sb = new StringBuilder();
            if (lastSepIndex != -1) {
                sb.append("<html><body>");
                sb.append(uriString.substring(lastSepIndex + 1, uriString.length()));
                sb.append("    ");
                sb.append("<font color=\"gray\">");
                sb.append(uriString);
                sb.append("</font>");
                sb.append("</body></html>");
            } else {
                sb.append(uriString);
            }
            label.setText(sb.toString());
            label.setIcon(OntologyImportsAndNavigationPanel.this.owlEditorKit.getWorkspace().getOWLIconProvider().getIcon((OWLObject)ontology));
            return label;
        }
    }
}

