/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import javax.swing.Icon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.protege.editor.core.ui.view.DisposableAction;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.semanticweb.owlapi.model.OWLEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOWLTreeAction<E extends OWLEntity>
extends DisposableAction {
    private TreeSelectionModel selectionModel;
    private TreeSelectionListener selectionListener;

    public AbstractOWLTreeAction(String name, Icon icon, TreeSelectionModel selectionModel) {
        super(name, icon);
        this.selectionModel = selectionModel;
        this.selectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AbstractOWLTreeAction.this.reactToSelection();
            }
        };
        selectionModel.addTreeSelectionListener(this.selectionListener);
        this.setEnabled(this.canPerform(this.getSelectedOWLEntity()));
    }

    private void reactToSelection() {
        this.setEnabled(this.canPerform(this.getSelectedOWLEntity()));
    }

    protected abstract boolean canPerform(E var1);

    protected TreePath getSelectionPath() {
        return this.selectionModel.getSelectionPath();
    }

    protected void setSelectionPath(TreePath path) {
        this.selectionModel.setSelectionPath(path);
    }

    protected E getSelectedOWLEntity() {
        TreePath treePath = this.selectionModel.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (E)((OWLEntity)((OWLObjectTreeNode)treePath.getLastPathComponent()).getUserObject());
    }

    public void dispose() {
        this.selectionModel.removeTreeSelectionListener(this.selectionListener);
    }

    public void initialise() throws Exception {
    }
}

