/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.preferences.PreferencesDialogPanel;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.model.refactor.ontology.ConvertEntityURIsToIdentifierPattern;
import org.protege.editor.owl.model.refactor.ontology.OntologyTargetResolver;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.editor.owl.ui.selector.OWLOntologySelectorPanel;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertEntityURIsToLabels
extends ProtegeOWLAction {
    private JRadioButton askButton;
    private boolean ask = true;

    public void actionPerformed(ActionEvent e) {
        if (this.getOWLModelManager().getOntologies().size() == 1) {
            JComponent selPanel = this.createConfirmPanel(false);
            int ret = new UIHelper(this.getOWLEditorKit()).showDialog("Convert entity URIs to labels", selPanel);
            if (ret == 0) {
                this.performConversion(null);
            }
        } else {
            JComponent selPanel = this.createConfirmPanel(true);
            int ret = new UIHelper(this.getOWLEditorKit()).showDialog("Convert entity URIs to labels", selPanel);
            if (ret == 0) {
                OntologyTargetResolver resolver;
                if (this.askButton.isSelected()) {
                    this.ask = true;
                    resolver = new OntologyTargetResolver(){

                        @Override
                        public Set<OWLOntology> resolve(OWLEntity entity, Set<OWLOntology> ontologies) {
                            return ConvertEntityURIsToLabels.this.handleResolveTarget(entity, ontologies);
                        }
                    };
                } else {
                    this.ask = false;
                    resolver = new OntologyTargetResolver(){

                        @Override
                        public Set<OWLOntology> resolve(OWLEntity entity, Set<OWLOntology> ontologies) {
                            return ontologies;
                        }
                    };
                }
                this.performConversion(resolver);
            }
        }
    }

    private void performConversion(OntologyTargetResolver resolver) {
        ConvertEntityURIsToIdentifierPattern converter = new ConvertEntityURIsToIdentifierPattern(this.getOWLModelManager(), this.getOWLModelManager().getOntologies());
        if (resolver != null) {
            converter.setOntologyResolver(resolver);
        }
        converter.performConversion();
        converter.dispose();
    }

    private JComponent createConfirmPanel(boolean showOption) {
        JPanel selPanel = new JPanel(new BorderLayout(8, 12));
        JEditorPane label = ComponentFactory.createHTMLPane((HyperlinkListener)new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    ConvertEntityURIsToLabels.this.showNewEntitiesPrefs();
                }
            }
        });
        StringBuffer html = new StringBuffer("<html><body>");
        html.append("For each entity missing a label in the currently loaded ontologies:<ul>");
        html.append("<li>create a label annotation using its current URI fragment</li>");
        html.append("<li>change its URI to an auto ID</li>");
        html.append("</ul>This conversion uses the current settings in <a href='#'>Preferences | New Entities</a>.");
        if (showOption) {
            html.append("<p>Protege will automatically detect the lowest ontologies in the import graph in which to add labels.<br>");
            html.append("If more than one is found what would you like to do?");
            this.askButton = new JRadioButton("Always ask me for confirmation", this.ask);
            JRadioButton addToAllReferencingOntologiesButton = new JRadioButton("Automatically add labels to all ontologies found", !this.ask);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.askButton);
            bg.add(addToAllReferencingOntologiesButton);
            Box optionsPanel = new Box(3);
            optionsPanel.setBorder(new EmptyBorder(0, 25, 0, 0));
            optionsPanel.add(this.askButton);
            optionsPanel.add(addToAllReferencingOntologiesButton);
            selPanel.add((Component)optionsPanel, "Center");
        }
        html.append("</body></html>");
        label.setText(html.toString());
        selPanel.add((Component)label, "North");
        return selPanel;
    }

    private void showNewEntitiesPrefs() {
        PreferencesDialogPanel.showPreferencesDialog((String)"New Entities", (EditorKit)this.getEditorKit());
    }

    private Set<OWLOntology> handleResolveTarget(OWLEntity entity, Set<OWLOntology> ontologies) {
        OWLOntologySelectorPanel ontPanel = new OWLOntologySelectorPanel(this.getOWLEditorKit(), ontologies);
        ontPanel.setSelection(ontologies.iterator().next());
        ontPanel.setMultipleSelectionEnabled(true);
        int ret = new UIHelper(this.getOWLEditorKit()).showDialog("Select ontologies that will contain a label for " + this.getOWLModelManager().getRendering((OWLObject)entity), ontPanel);
        if (ret == 0) {
            return ontPanel.getSelectedOntologies();
        }
        return Collections.emptySet();
    }

    public void initialise() throws Exception {
    }

    public void dispose() {
    }
}

