/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.List;
import org.protege.editor.owl.ui.action.FocusedComponentAction;
import org.protege.editor.owl.ui.transfer.TransferableOWLObject;
import org.protege.editor.owl.ui.view.Copyable;
import org.protege.editor.owl.ui.view.ViewClipboard;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyAction
extends FocusedComponentAction<Copyable> {
    @Override
    protected boolean canPerform() {
        return ((Copyable)this.getCurrentTarget()).canCopy();
    }

    @Override
    protected Class<Copyable> initialiseAction() {
        return Copyable.class;
    }

    public void actionPerformed(ActionEvent e) {
        List<OWLObject> objects = ((Copyable)this.getCurrentTarget()).getObjectsToCopy();
        if (objects.isEmpty()) {
            return;
        }
        ViewClipboard clipboard = ViewClipboard.getInstance();
        clipboard.getClipboard().setContents(new TransferableOWLObject(this.getOWLModelManager(), objects), null);
        new TransferableOWLObject(this.getOWLModelManager(), objects);
        StringBuilder buffer = new StringBuilder();
        for (OWLObject owlObject : objects) {
            buffer.append(this.getOWLModelManager().getRendering(owlObject));
            buffer.append("\n");
        }
        StringSelection stringSelection = new StringSelection(buffer.toString().trim());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }
}

