/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Component;
import java.util.Set;
import javax.swing.JOptionPane;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.owl.ui.action.SelectedOWLEntityAction;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLEntityRemover;

public class DeleteEntityAction
extends SelectedOWLEntityAction {
    protected void actionPerformed(OWLEntity selectedEntity) {
        boolean containsReferences = false;
        block0: for (OWLOntology ont : this.getOWLModelManager().getOntologies()) {
            Set referencingAxioms = ont.getReferencingAxioms(selectedEntity);
            for (OWLAxiom ax : referencingAxioms) {
                if (ax instanceof OWLDeclarationAxiom) continue;
                containsReferences = true;
                continue block0;
            }
        }
        if (containsReferences) {
            int ret = this.showUsageConfirmationDialog();
            if (ret == 1) {
                this.showUsage();
            } else if (ret == 0) {
                this.deleteEntity();
            }
        } else {
            int ret = this.showConfirmationDialog();
            if (ret == 0) {
                this.deleteEntity();
            }
        }
    }

    private int showConfirmationDialog() {
        String rendering = this.getOWLModelManager().getRendering((OWLObject)this.getSelectedEntity());
        return JOptionPane.showConfirmDialog((Component)((Object)this.getOWLWorkspace()), "Delete " + rendering + "?", "Really delete?", 0, 2);
    }

    private int showUsageConfirmationDialog() {
        String rendering = this.getOWLModelManager().getRendering((OWLObject)this.getSelectedEntity());
        Object[] OPTIONS2 = new Object[]{"Delete", "View usage", "Cancel"};
        return JOptionPane.showOptionDialog((Component)((Object)this.getOWLWorkspace()), rendering + " is used throught the loaded ontologies.  Delete anyway?", "Entity is referenced!", -1, 2, null, OPTIONS2, OPTIONS2[1]);
    }

    private void deleteEntity() {
        OWLEntityRemover remover = new OWLEntityRemover(this.getOWLModelManager().getOWLOntologyManager(), this.getOWLModelManager().getOntologies());
        this.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity().accept((OWLEntityVisitor)remover);
        this.getOWLModelManager().applyChanges(remover.getChanges());
    }

    private void showUsage() {
        OWLEntity ent = this.getSelectedEntity();
        ent.accept(new OWLEntityVisitor(){

            public void visit(OWLClass cls) {
                View view = DeleteEntityAction.this.getOWLWorkspace().showResultsView("OWLClassUsageView", true, 0);
                view.setPinned(true);
            }

            public void visit(OWLDatatype dataType) {
            }

            public void visit(OWLAnnotationProperty owlAnnotationProperty) {
                View view = DeleteEntityAction.this.getOWLWorkspace().showResultsView("OWLAnnotationPropertyUsageView", true, 0);
                view.setPinned(true);
            }

            public void visit(OWLNamedIndividual individual) {
                View view = DeleteEntityAction.this.getOWLWorkspace().showResultsView("OWLIndividualUsageView", true, 0);
                view.setPinned(true);
            }

            public void visit(OWLDataProperty property) {
                View view = DeleteEntityAction.this.getOWLWorkspace().showResultsView("OWLDataPropertyUsageView", true, 0);
                view.setPinned(true);
            }

            public void visit(OWLObjectProperty property) {
                View view = DeleteEntityAction.this.getOWLWorkspace().showResultsView("OWLObjectPropertyUsageView", true, 0);
                view.setPinned(true);
            }
        });
    }

    protected void disposeAction() throws Exception {
    }
}

