/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.action.RemoveAllDisjointAxiomsAction;
import org.protege.editor.owl.ui.action.SelectedOWLClassAction;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveLocalDisjointAxiomsAction
extends SelectedOWLClassAction {
    private static final Logger logger = Logger.getLogger(RemoveAllDisjointAxiomsAction.class);

    public void actionPerformed(ActionEvent e) {
        try {
            UIHelper uiHelper = new UIHelper(this.getOWLEditorKit());
            int result = uiHelper.showOptionPane("Include imported ontologies?", "Do you want to remove the disjoint axioms from \nimported ontologies?", 1, 3);
            HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>();
            if (result == 0) {
                ontologies.addAll(this.getOWLModelManager().getActiveOntologies());
            } else if (result == 1) {
                ontologies = Collections.singleton(this.getOWLModelManager().getActiveOntology());
            }
            ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
            for (OWLClass desc : this.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getChildren(this.getOWLClass())) {
                changes.addAll(this.removeDisjointsForClass(desc, ontologies));
            }
            this.getOWLModelManager().applyChanges(changes);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
    }

    private List<OWLOntologyChange> removeDisjointsForClass(OWLClass owlClass, Set<OWLOntology> ontologies) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : ontologies) {
            for (OWLDisjointClassesAxiom ax : ont.getAxioms(AxiomType.DISJOINT_CLASSES)) {
                if (!ax.getClassExpressions().contains(owlClass)) continue;
                changes.add((OWLOntologyChange)new RemoveAxiom(ont, (OWLAxiom)ax));
            }
        }
        return changes;
    }

    @Override
    protected void initialiseAction() throws Exception {
    }
}

