/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.util.List;
import org.protege.editor.owl.ui.action.SelectedOWLEntityAction;
import org.protege.editor.owl.ui.rename.RenameEntityPanel;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.OWLEntityRenamer;

public class RenameEntityAction
extends SelectedOWLEntityAction {
    protected void actionPerformed(OWLEntity selectedEntity) {
        OWLEntityRenamer owlEntityRenamer = new OWLEntityRenamer(this.getOWLModelManager().getOWLOntologyManager(), this.getOWLModelManager().getOntologies());
        final IRI iri = RenameEntityPanel.showDialog(this.getOWLEditorKit(), selectedEntity);
        if (iri == null) {
            return;
        }
        List changes = RenameEntityPanel.isAutoRenamePuns() ? owlEntityRenamer.changeIRI(selectedEntity.getIRI(), iri) : owlEntityRenamer.changeIRI(selectedEntity, iri);
        this.getOWLModelManager().applyChanges(changes);
        selectedEntity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass cls) {
                RenameEntityAction.this.ensureSelected((OWLEntity)RenameEntityAction.this.getOWLDataFactory().getOWLClass(iri));
            }

            public void visit(OWLObjectProperty property) {
                RenameEntityAction.this.ensureSelected((OWLEntity)RenameEntityAction.this.getOWLDataFactory().getOWLObjectProperty(iri));
            }

            public void visit(OWLDataProperty property) {
                RenameEntityAction.this.ensureSelected((OWLEntity)RenameEntityAction.this.getOWLDataFactory().getOWLDataProperty(iri));
            }

            public void visit(OWLAnnotationProperty owlAnnotationProperty) {
                RenameEntityAction.this.ensureSelected((OWLEntity)RenameEntityAction.this.getOWLDataFactory().getOWLDataProperty(iri));
            }

            public void visit(OWLNamedIndividual individual) {
                RenameEntityAction.this.ensureSelected((OWLEntity)RenameEntityAction.this.getOWLDataFactory().getOWLNamedIndividual(iri));
            }

            public void visit(OWLDatatype dataType) {
                RenameEntityAction.this.ensureSelected((OWLEntity)RenameEntityAction.this.getOWLDataFactory().getOWLDatatype(iri));
            }
        });
    }

    private void ensureSelected(OWLEntity entity) {
        this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity(entity);
    }

    protected void disposeAction() throws Exception {
    }
}

