/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import org.protege.editor.core.ui.view.View;
import org.protege.editor.owl.ui.action.SelectedOWLEntityAction;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class ShowUsageAction
extends SelectedOWLEntityAction {
    protected void actionPerformed(OWLEntity selectedEntity) {
        OWLEntity ent = this.getSelectedEntity();
        if (ent == null) {
            return;
        }
        ent.accept(new OWLEntityVisitor(){

            public void visit(OWLClass cls) {
                this.showResultsView("org.protege.editor.owl.OWLClassUsageView");
            }

            public void visit(OWLDataProperty property) {
                this.showResultsView("org.protege.editor.owl.OWLDataPropertyUsageView");
            }

            public void visit(OWLObjectProperty property) {
                this.showResultsView("org.protege.editor.owl.OWLObjectPropertyUsageView");
            }

            public void visit(OWLAnnotationProperty owlAnnotationProperty) {
                this.showResultsView("org.protege.editor.owl.OWLAnnotationPropertyUsageView");
            }

            public void visit(OWLNamedIndividual individual) {
                this.showResultsView("org.protege.editor.owl.OWLIndividualUsageView");
            }

            public void visit(OWLDatatype dataType) {
            }

            private void showResultsView(String viewId) {
                View view = ShowUsageAction.this.getOWLWorkspace().showResultsView(viewId, true, 0);
                if (view != null) {
                    view.setPinned(true);
                }
            }
        });
    }

    protected void disposeAction() throws Exception {
    }
}

