/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDisjointClassesAction
extends ProtegeOWLAction {
    Logger logger = Logger.getLogger(SplitDisjointClassesAction.class);

    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<Object> changes = new ArrayList<Object>();
        int axiomsRemoved = 0;
        int axiomsAdded = 0;
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            for (OWLDisjointClassesAxiom ax : ont.getAxioms(AxiomType.DISJOINT_CLASSES)) {
                Set<OWLDisjointClassesAxiom> pairwiseAxioms = this.split(ax);
                if (pairwiseAxioms.isEmpty()) continue;
                changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                ++axiomsRemoved;
                for (OWLDisjointClassesAxiom pairwiseAxiom : pairwiseAxioms) {
                    changes.add(new AddAxiom(ont, (OWLAxiom)pairwiseAxiom));
                    ++axiomsAdded;
                }
            }
        }
        this.getOWLModelManager().applyChanges(changes);
        this.logger.info((Object)("Split " + axiomsRemoved + " disjointClasses axioms into " + axiomsAdded + " pairwise axioms"));
    }

    public Set<OWLDisjointClassesAxiom> split(OWLDisjointClassesAxiom ax) {
        HashSet<OWLDisjointClassesAxiom> pairwiseAxioms = new HashSet<OWLDisjointClassesAxiom>();
        if (ax.getClassExpressions().size() > 2) {
            ArrayList orderedOperands = new ArrayList(ax.getClassExpressions());
            for (int i = 0; i < orderedOperands.size(); ++i) {
                OWLClassExpression a = (OWLClassExpression)orderedOperands.get(i);
                for (int j = i + 1; j < orderedOperands.size(); ++j) {
                    OWLClassExpression b = (OWLClassExpression)orderedOperands.get(j);
                    OWLDisjointClassesAxiom pairwiseAxiom = this.getOWLDataFactory().getOWLDisjointClassesAxiom(new OWLClassExpression[]{a, b});
                    pairwiseAxioms.add(pairwiseAxiom);
                }
            }
        }
        return pairwiseAxioms;
    }

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
    }
}

