/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.axiom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.util.OWLAxiomInstance;
import org.protege.editor.owl.ui.list.AbstractAnnotationsList;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxiomAnnotationsList
extends AbstractAnnotationsList<OWLAxiomInstance> {
    private OWLAxiom newAxiom;

    public AxiomAnnotationsList(OWLEditorKit eKit) {
        super(eKit);
    }

    @Override
    protected List<OWLOntologyChange> getAddChanges(OWLAnnotation annot) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLAxiom oldAxiom = ((OWLAxiomInstance)this.getRoot()).getAxiom();
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>(oldAxiom.getAnnotations());
        annotations.add(annot);
        this.newAxiom = oldAxiom.getAxiomWithoutAnnotations().getAnnotatedAxiom(annotations);
        OWLOntology ont = ((OWLAxiomInstance)this.getRoot()).getOntology();
        changes.add((OWLOntologyChange)new RemoveAxiom(ont, oldAxiom));
        changes.add((OWLOntologyChange)new AddAxiom(ont, this.newAxiom));
        return changes;
    }

    @Override
    protected List<OWLOntologyChange> getReplaceChanges(OWLAnnotation oldAnnotation, OWLAnnotation newAnnotation) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLAxiom ax = ((OWLAxiomInstance)this.getRoot()).getAxiom();
        OWLOntology ont = ((OWLAxiomInstance)this.getRoot()).getOntology();
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>(ax.getAnnotations());
        annotations.remove(oldAnnotation);
        annotations.add(newAnnotation);
        this.newAxiom = ax.getAxiomWithoutAnnotations().getAnnotatedAxiom(annotations);
        changes.add((OWLOntologyChange)new RemoveAxiom(ont, ax));
        changes.add((OWLOntologyChange)new AddAxiom(ont, this.newAxiom));
        return changes;
    }

    @Override
    protected List<OWLOntologyChange> getDeleteChanges(OWLAnnotation oldAnnotation) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLAxiom ax = ((OWLAxiomInstance)this.getRoot()).getAxiom();
        OWLOntology ont = ((OWLAxiomInstance)this.getRoot()).getOntology();
        HashSet annotations = new HashSet(ax.getAnnotations());
        annotations.remove(oldAnnotation);
        this.newAxiom = ax.getAxiomWithoutAnnotations().getAnnotatedAxiom(annotations);
        changes.add((OWLOntologyChange)new RemoveAxiom(ont, ax));
        changes.add((OWLOntologyChange)new AddAxiom(ont, this.newAxiom));
        return changes;
    }

    @Override
    protected void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        if (this.newAxiom != null) {
            for (OWLOntologyChange oWLOntologyChange : changes) {
                if (!(oWLOntologyChange instanceof RemoveAxiom) || !oWLOntologyChange.getAxiom().equals(((OWLAxiomInstance)this.getRoot()).getAxiom())) continue;
                this.setRootObject(new OWLAxiomInstance(this.newAxiom, ((OWLAxiomInstance)this.getRoot()).getOntology()));
                this.newAxiom = null;
                return;
            }
        }
    }
}

