/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.clsdescriptioneditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditorPreferences;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLAutoCompleter;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionHistoryCompleter;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEditor<O>
extends JTextPane
implements RefreshableComponent,
VerifiedInputEditor {
    private static Logger logger = Logger.getLogger(ExpressionEditor.class);
    private Border outerBorder;
    private OWLEditorKit owlEditorKit;
    private Border defaultBorder;
    private Border stateBorder;
    private Border errorBorder;
    private Stroke errorStroke;
    private DocumentListener docListener;
    private int errorStartIndex;
    private int errorEndIndex;
    private Timer timer;
    private static final int DEFAULT_TOOL_TIP_INITIAL_DELAY = ToolTipManager.sharedInstance().getInitialDelay();
    private static final int DEFAULT_TOOL_TIP_DISMISS_DELAY = ToolTipManager.sharedInstance().getDismissDelay();
    private static final int ERROR_TOOL_TIP_INITIAL_DELAY = 100;
    private static final int ERROR_TOOL_TIP_DISMISS_DELAY = 9000;
    private OWLExpressionChecker<O> expressionChecker;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private boolean previousValue = true;

    public ExpressionEditor(OWLEditorKit owlEditorKit, OWLExpressionChecker<O> checker) {
        this.owlEditorKit = owlEditorKit;
        this.outerBorder = null;
        this.expressionChecker = checker;
        this.defaultBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY);
        this.setStateBorder(this.defaultBorder);
        this.errorBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.RED);
        this.errorStroke = new BasicStroke(3.0f, 0, 1, 3.0f, new float[]{4.0f, 2.0f}, 0.0f);
        this.docListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ExpressionEditor.this.handleDocumentUpdated();
            }

            public void removeUpdate(DocumentEvent e) {
                ExpressionEditor.this.handleDocumentUpdated();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.getDocument().addDocumentListener(this.docListener);
        this.timer = new Timer(ExpressionEditorPreferences.getInstance().getCheckDelay(), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionEditor.this.handleTimer();
            }
        });
        this.refreshComponent();
        new OWLAutoCompleter(owlEditorKit, this, checker);
        new OWLExpressionHistoryCompleter(owlEditorKit, this);
        this.createStyles();
    }

    public void refreshComponent() {
        this.setFont(OWLRendererPreferences.getInstance().getFont());
    }

    public void setExpressionObject(O desc) {
        if (desc == null) {
            this.setText("");
        } else if (desc instanceof OWLObject) {
            OWLModelManager mngr = this.getOWLEditorKit().getModelManager();
            String rendering = mngr.getRendering((OWLObject)desc);
            this.setText(rendering);
        } else if (desc instanceof Collection) {
            OWLModelManager mngr = this.getOWLEditorKit().getModelManager();
            StringBuffer sb = new StringBuffer();
            for (Object obj : (Collection)desc) {
                if (!(obj instanceof OWLObject)) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(mngr.getRendering((OWLObject)obj));
            }
            this.setText(sb.toString());
        } else {
            this.setText(desc.toString());
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public OWLExpressionChecker<O> getExpressionChecker() {
        return this.expressionChecker;
    }

    public O createObject() throws OWLException {
        return this.expressionChecker.createObject(this.getText());
    }

    public void setStateBorder(Border border) {
        this.stateBorder = border;
        super.setBorder(BorderFactory.createCompoundBorder(this.outerBorder, this.stateBorder));
    }

    @Override
    public void setBorder(Border border) {
        this.outerBorder = border;
        super.setBorder(BorderFactory.createCompoundBorder(this.outerBorder, this.stateBorder));
    }

    private void clearError() {
        this.setToolTipText(null);
        this.setStateBorder(this.defaultBorder);
        this.setErrorRange(0, 0);
        ToolTipManager.sharedInstance().setInitialDelay(DEFAULT_TOOL_TIP_INITIAL_DELAY);
        ToolTipManager.sharedInstance().setDismissDelay(DEFAULT_TOOL_TIP_DISMISS_DELAY);
    }

    public boolean isWellFormed() {
        try {
            this.expressionChecker.check(this.getText());
            return true;
        }
        catch (OWLException e) {
            return false;
        }
    }

    protected void checkExpression() {
        try {
            this.expressionChecker.check(this.getText());
            this.setError(null);
        }
        catch (OWLExpressionParserException e) {
            this.setError(e);
        }
        catch (Throwable e) {
            logger.error((Object)e);
        }
    }

    private void handleTimer() {
        this.timer.stop();
        this.checkExpression();
    }

    private void handleDocumentUpdated() {
        this.timer.restart();
        this.clearError();
        this.performHighlighting();
        this.notifyValidationChanged(false);
    }

    private void setError(OWLExpressionParserException e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set error " + (Object)((Object)e)));
        }
        this.notifyValidationChanged(e == null);
        if (e != null) {
            ToolTipManager.sharedInstance().setInitialDelay(100);
            ToolTipManager.sharedInstance().setDismissDelay(9000);
            this.setToolTipText(ExpressionEditor.getHTMLErrorMessage(e.getMessage()));
            this.setStateBorder(this.errorBorder);
            this.setErrorRange(e.getStartIndex(), e.getEndIndex());
        } else {
            this.clearError();
        }
    }

    private void setErrorRange(int startIndex, int endIndex) {
        this.errorStartIndex = startIndex;
        this.errorEndIndex = endIndex;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        try {
            if (this.errorStartIndex != this.errorEndIndex && this.errorStartIndex > -1 && this.errorStartIndex < this.getDocument().getLength()) {
                Rectangle start = this.modelToView(this.errorStartIndex);
                Rectangle end = this.modelToView(this.errorEndIndex);
                g.setColor(Color.RED);
                ((Graphics2D)g).setStroke(this.errorStroke);
                int y = end.y + end.height;
                g.drawLine(start.x, y, end.x + end.width, y);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        g.setColor(oldColor);
    }

    private void performHighlighting() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    boolean lineStartIndex = false;
                    int lineEndIndex = ExpressionEditor.this.getDocument().getLength();
                    if (lineEndIndex - 0 < 0) {
                        return;
                    }
                    StringTokenizer tokenizer = new StringTokenizer(ExpressionEditor.this.getDocument().getText(0, lineEndIndex - 0), " ()[]{},\n\t.'", true);
                    int index = 0;
                    boolean inEscapedName = false;
                    while (tokenizer.hasMoreTokens()) {
                        String curToken = tokenizer.nextToken();
                        if (curToken.equals("'")) {
                            inEscapedName = !inEscapedName;
                        }
                        if (!inEscapedName) {
                            Color color = ExpressionEditor.this.owlEditorKit.getWorkspace().getKeyWordColorMap().get(curToken);
                            if (color == null) {
                                color = Color.BLACK;
                            }
                            ExpressionEditor.this.getStyledDocument().setCharacterAttributes(index, curToken.length(), ExpressionEditor.this.getStyledDocument().getStyle(color.toString()), true);
                        }
                        index += curToken.length();
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
    }

    private static String getHTMLErrorMessage(String msg) {
        String html = "<html><body>";
        msg = msg.replace("\n", "<br>");
        msg = msg.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        html = html + msg;
        html = html + "</body></html>";
        return html;
    }

    private void createStyles() {
        for (Color color : this.owlEditorKit.getWorkspace().getKeyWordColorMap().values()) {
            Style style = this.getStyledDocument().addStyle(color.toString(), null);
            StyleConstants.setForeground(style, color);
            StyleConstants.setBold(style, true);
        }
        StyleConstants.setForeground(this.getStyledDocument().addStyle(Color.BLACK.toString(), null), Color.BLACK);
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyValidationChanged(boolean valid) {
        if (valid != this.previousValue) {
            this.previousValue = valid;
            for (InputVerificationStatusChangedListener l : this.listeners) {
                l.verifiedStatusChanged(valid);
            }
        }
    }
}

