/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.ui.editor.AbstractOWLClassExpressionEditor;
import org.protege.editor.owl.ui.selector.AbstractHierarchySelectorPanel;
import org.protege.editor.owl.ui.selector.AbstractSelectorPanel;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRestrictionCreatorPanel<P extends OWLProperty, F extends OWLObject>
extends AbstractOWLClassExpressionEditor {
    private JPanel panel;
    private AbstractHierarchySelectorPanel<P> propertySelectorPanel;
    private AbstractSelectorPanel<F> fillerSelectorPanel;
    private JSpinner cardinalitySpinner;
    private JComboBox typeCombo;
    private boolean currentStatus = false;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private ChangeListener selListener = new ChangeListener(){

        public void stateChanged(ChangeEvent event) {
            AbstractRestrictionCreatorPanel.this.checkStatus();
        }
    };

    public void initialise() throws Exception {
        this.panel = new JPanel();
        this.propertySelectorPanel = this.createPropertySelectorPanel();
        this.propertySelectorPanel.addSelectionListener(this.selListener);
        this.propertySelectorPanel.setBorder(ComponentFactory.createTitledBorder((String)"Restricted property"));
        this.fillerSelectorPanel = this.createFillerSelectorPanel();
        this.propertySelectorPanel.addSelectionListener(this.selListener);
        this.fillerSelectorPanel.setBorder(ComponentFactory.createTitledBorder((String)"Restriction filler"));
        this.panel.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, false);
        splitPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        splitPane.setResizeWeight(0.5);
        splitPane.setLeftComponent(this.propertySelectorPanel);
        splitPane.setRightComponent(this.fillerSelectorPanel);
        this.panel.add(splitPane);
        List<RestrictionCreator<P, F>> types = this.createTypes();
        this.typeCombo = new JComboBox<Object>(types.toArray());
        this.cardinalitySpinner = new JSpinner(new SpinnerNumberModel(1, 0, Integer.MAX_VALUE, 1));
        JComponent cardinalitySpinnerEditor = this.cardinalitySpinner.getEditor();
        Dimension prefSize = cardinalitySpinnerEditor.getPreferredSize();
        cardinalitySpinnerEditor.setPreferredSize(new Dimension(50, prefSize.height));
        JPanel typePanel = new JPanel();
        typePanel.setBorder(ComponentFactory.createTitledBorder((String)"Restriction type"));
        this.panel.add((Component)typePanel, "South");
        typePanel.add(this.typeCombo);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractRestrictionCreatorPanel.this.cardinalitySpinner.setEnabled(AbstractRestrictionCreatorPanel.this.typeCombo.getSelectedItem() instanceof CardinalityRestrictionCreator);
            }
        });
        JPanel spinnerHolder = new JPanel(new BorderLayout(4, 4));
        spinnerHolder.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        spinnerHolder.add((Component)new JLabel("Cardinality"), "West");
        spinnerHolder.add((Component)this.cardinalitySpinner, "East");
        JPanel spinnerAlignmentPanel = new JPanel(new BorderLayout());
        spinnerAlignmentPanel.add((Component)spinnerHolder, "West");
        typePanel.add(spinnerAlignmentPanel);
        this.cardinalitySpinner.setEnabled(this.typeCombo.getSelectedItem() instanceof CardinalityRestrictionCreator);
    }

    protected abstract List<RestrictionCreator<P, F>> createTypes();

    protected abstract AbstractSelectorPanel<F> createFillerSelectorPanel();

    protected abstract AbstractHierarchySelectorPanel<P> createPropertySelectorPanel();

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public Set<OWLClassExpression> getClassExpressions() {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        RestrictionCreator creator = (RestrictionCreator)this.typeCombo.getSelectedItem();
        if (creator == null) {
            return Collections.emptySet();
        }
        creator.createRestrictions(this.propertySelectorPanel.getSelectedObjects(), new HashSet<F>(this.fillerSelectorPanel.getSelectedObjects()), result);
        return result;
    }

    protected final OWLDataFactory getDataFactory() {
        return this.getOWLEditorKit().getModelManager().getOWLDataFactory();
    }

    public void dispose() {
        this.propertySelectorPanel.dispose();
        this.fillerSelectorPanel.dispose();
        this.panel = null;
    }

    private void checkStatus() {
        boolean newStatus = this.isValidInput();
        if (this.currentStatus != newStatus) {
            this.currentStatus = newStatus;
            for (InputVerificationStatusChangedListener l : this.listeners) {
                l.verifiedStatusChanged(newStatus);
            }
        }
    }

    protected void setType(RestrictionCreator type) {
        this.typeCombo.setSelectedItem(type);
    }

    protected void setProperty(P property) {
        this.propertySelectorPanel.setSelection(property);
    }

    protected void setFiller(F filler) {
        this.fillerSelectorPanel.setSelection(filler);
    }

    protected void setCardinality(int cardinality) {
        this.cardinalitySpinner.setValue(cardinality);
    }

    @Override
    public boolean isValidInput() {
        return this.propertySelectorPanel.getSelectedObject() != null && this.fillerSelectorPanel.getSelectedObject() != null;
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        listener.verifiedStatusChanged(this.currentStatus);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class CardinalityRestrictionCreator<P extends OWLProperty, F extends OWLObject>
    extends RestrictionCreator<P, F> {
        protected CardinalityRestrictionCreator(String name) {
            super(name);
        }

        @Override
        public void createRestrictions(Set<P> properties, Set<F> fillers, Set<OWLClassExpression> result) {
            for (OWLProperty prop : properties) {
                for (OWLObject desc : fillers) {
                    result.add(this.createRestriction(prop, desc, (Integer)AbstractRestrictionCreatorPanel.this.cardinalitySpinner.getValue()));
                }
            }
        }

        public abstract OWLClassExpression createRestriction(P var1, F var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class RestrictionCreator<P extends OWLProperty, F extends OWLObject> {
        private String name;

        protected RestrictionCreator(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        abstract void createRestrictions(Set<P> var1, Set<F> var2, Set<OWLClassExpression> var3);
    }
}

