/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRITextEditor
implements OWLObjectEditor<IRI>,
VerifiedInputEditor {
    private OWLObjectEditorHandler<IRI> handler;
    private JPanel editor;
    private JTextField iriTextField;
    private List<InputVerificationStatusChangedListener> inputVerificationListeners = new ArrayList<InputVerificationStatusChangedListener>();

    public IRITextEditor(OWLEditorKit editorKit) {
        this.createGui();
        this.setInitialIri(editorKit);
    }

    private void createGui() {
        this.editor = new JPanel();
        this.editor.setLayout(new FlowLayout());
        this.editor.add(new JLabel("IRI: "));
        this.iriTextField = new JTextField();
        this.iriTextField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                for (InputVerificationStatusChangedListener listener : IRITextEditor.this.inputVerificationListeners) {
                    listener.verifiedStatusChanged(IRITextEditor.this.getEditedObject() != null);
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.editor.add(this.iriTextField);
    }

    private void setInitialIri(OWLEditorKit editorKit) {
        OWLOntology ontology = editorKit.getOWLModelManager().getActiveOntology();
        OWLOntologyID ontologyId = ontology.getOntologyID();
        if (!ontologyId.isAnonymous()) {
            this.iriTextField.setText(ontologyId.getOntologyIRI().toString());
        }
    }

    @Override
    public String getEditorTypeName() {
        return "IRI Editor";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof IRI;
    }

    @Override
    public boolean isMultiEditSupported() {
        return false;
    }

    public boolean isPreferred() {
        return false;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editor;
    }

    @Override
    public boolean setEditedObject(IRI editedObject) {
        if (editedObject != null && editedObject instanceof IRI) {
            this.iriTextField.setText(editedObject.toString());
        }
        return editedObject != null;
    }

    @Override
    public IRI getEditedObject() {
        IRI editedObject = null;
        try {
            editedObject = IRI.create((String)this.iriTextField.getText());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return editedObject;
    }

    @Override
    public Set<IRI> getEditedObjects() {
        IRI editedObject = this.getEditedObject();
        if (editedObject != null) {
            return Collections.singleton(editedObject);
        }
        return Collections.emptySet();
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.inputVerificationListeners.add(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.inputVerificationListeners.remove(listener);
    }

    @Override
    public OWLObjectEditorHandler<IRI> getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(OWLObjectEditorHandler<IRI> handler) {
        this.handler = handler;
    }

    @Override
    public void clear() {
    }

    @Override
    public void dispose() {
    }
}

