/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.protege.editor.owl.ui.frame.OWLAnnotationFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLClassAssertionAxiomTypeFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLIndividualPropertyAssertionsFrame;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAnonymousIndividualAnnotationValueEditor
implements OWLObjectEditor<OWLAnonymousIndividual> {
    private OWLFrameList<OWLAnonymousIndividual> frameList;
    private JComponent mainComponent;
    private OWLEditorKit editorKit;
    private JLabel annotationValueLabel;
    private OWLObjectEditorHandler<OWLAnonymousIndividual> handler;

    public OWLAnonymousIndividualAnnotationValueEditor(OWLEditorKit owlEditorKit) {
        this.editorKit = owlEditorKit;
        OWLAnonymousIndividualPropertyAssertionsFrame frame = new OWLAnonymousIndividualPropertyAssertionsFrame(owlEditorKit);
        this.frameList = new OWLFrameList<OWLAnonymousIndividual>(owlEditorKit, frame);
        this.mainComponent = new JPanel(new BorderLayout(7, 7));
        JScrollPane sp = new JScrollPane((Component)((Object)this.frameList));
        JPanel scrollPaneHolder = new JPanel(new BorderLayout());
        scrollPaneHolder.add(sp);
        scrollPaneHolder.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
        this.mainComponent.add(scrollPaneHolder);
        this.annotationValueLabel = new JLabel();
        this.mainComponent.add((Component)this.annotationValueLabel, "North");
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLIndividual;
    }

    public boolean isPreferred(Object object) {
        return object instanceof OWLIndividual && ((OWLIndividual)object).isAnonymous();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.mainComponent;
    }

    @Override
    public OWLAnonymousIndividual getEditedObject() {
        return this.frameList.getRootObject();
    }

    @Override
    public Set<OWLAnonymousIndividual> getEditedObjects() {
        return Collections.singleton(this.getEditedObject());
    }

    @Override
    public boolean setEditedObject(OWLAnonymousIndividual object) {
        if (object == null) {
            String id = "genid" + System.nanoTime();
            OWLOntologyID ontologyID = this.editorKit.getModelManager().getActiveOntology().getOntologyID();
            if (!ontologyID.isAnonymous()) {
                id = ontologyID.getOntologyIRI() + "#" + id;
            }
            object = this.editorKit.getModelManager().getOWLDataFactory().getOWLAnonymousIndividual(id);
        }
        this.frameList.setRootObject(object);
        if (object != null) {
            this.mainComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.annotationValueLabel.setIcon(OWLIcons.getIcon("individual.png"));
            this.annotationValueLabel.setText(this.editorKit.getModelManager().getRendering((OWLObject)object));
        } else {
            this.annotationValueLabel.setIcon(null);
            this.annotationValueLabel.setText("");
        }
        return true;
    }

    @Override
    public boolean isMultiEditSupported() {
        return false;
    }

    @Override
    public void clear() {
        this.setEditedObject(null);
    }

    @Override
    public String getEditorTypeName() {
        return "Property values";
    }

    @Override
    public void dispose() {
        this.frameList.dispose();
    }

    @Override
    public void setHandler(OWLObjectEditorHandler<OWLAnonymousIndividual> handler) {
        this.handler = handler;
    }

    @Override
    public OWLObjectEditorHandler<OWLAnonymousIndividual> getHandler() {
        return this.handler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OWLAnonymousIndividualPropertyAssertionsFrame
    extends OWLIndividualPropertyAssertionsFrame<OWLAnonymousIndividual> {
        public OWLAnonymousIndividualPropertyAssertionsFrame(OWLEditorKit owlEditorKit) {
            super(owlEditorKit);
            this.addSection(new OWLClassAssertionAxiomTypeFrameSection(owlEditorKit, this), 0);
            this.addSection(new OWLAnnotationFrameSection(owlEditorKit, this), 0);
        }
    }
}

