/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.cache.OWLExpressionUserCache;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLClassExpressionEditor;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassExpressionExpressionEditor
extends AbstractOWLClassExpressionEditor {
    private ExpressionEditor<OWLClassExpression> editor;
    private JScrollPane scroller;

    public void initialise() throws Exception {
        OWLEditorKit eKit = this.getOWLEditorKit();
        OWLExpressionChecker<OWLClassExpression> checker = eKit.getModelManager().getOWLExpressionCheckerFactory().getOWLClassExpressionChecker();
        this.editor = new ExpressionEditor<OWLClassExpression>(eKit, checker);
        this.scroller = new JScrollPane(this.editor);
    }

    @Override
    public JComponent getComponent() {
        return this.scroller;
    }

    @Override
    public boolean isValidInput() {
        return this.editor.isWellFormed();
    }

    @Override
    public boolean setDescription(OWLClassExpression description) {
        this.editor.setExpressionObject(description);
        return true;
    }

    @Override
    public Set<OWLClassExpression> getClassExpressions() {
        try {
            if (this.editor.isWellFormed()) {
                OWLClassExpression owlDescription = this.editor.createObject();
                OWLExpressionUserCache.getInstance(this.getOWLEditorKit().getModelManager()).add(owlDescription, this.editor.getText());
                return Collections.singleton(owlDescription);
            }
            return null;
        }
        catch (OWLException e) {
            return null;
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.editor.addStatusChangedListener(l);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.editor.removeStatusChangedListener(l);
    }

    public void dispose() throws Exception {
    }
}

