/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLClassSelectorPanel;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassExpressionSetEditor
extends AbstractOWLObjectEditor<Set<OWLClassExpression>>
implements VerifiedInputEditor {
    private static final Logger logger = Logger.getLogger(OWLClassExpressionSetEditor.class);
    private OWLEditorKit owlEditorKit;
    private OWLClassSelectorPanel classSelectorPanel;
    private JComponent editorComponent;
    private ExpressionEditor<Set<OWLClassExpression>> expressionEditor;
    private JTabbedPane tabbedPane;
    private List<OWLClassExpression> initialSelection;
    private List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent event) {
            for (InputVerificationStatusChangedListener l : OWLClassExpressionSetEditor.this.listeners) {
                l.verifiedStatusChanged(OWLClassExpressionSetEditor.this.isValid());
            }
        }
    };

    public OWLClassExpressionSetEditor(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
    }

    public OWLClassExpressionSetEditor(OWLEditorKit owlEditorKit, List<OWLClassExpression> selectedClasses) {
        this.owlEditorKit = owlEditorKit;
        this.initialSelection = selectedClasses;
    }

    private void createEditor() {
        this.editorComponent = new JPanel(new BorderLayout());
        OWLExpressionChecker<Set<OWLClassExpression>> checker = this.owlEditorKit.getModelManager().getOWLExpressionCheckerFactory().getOWLClassExpressionSetChecker();
        this.expressionEditor = new ExpressionEditor<Set<OWLClassExpression>>(this.owlEditorKit, checker);
        JPanel holderPanel = new JPanel(new BorderLayout());
        holderPanel.add(this.expressionEditor);
        holderPanel.setPreferredSize(new Dimension(500, 400));
        holderPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        if (this.initialSelection == null) {
            this.classSelectorPanel = new OWLClassSelectorPanel(this.owlEditorKit);
        } else {
            Set<OWLClass> clses = this.getNamedClassesFromInitialSelection();
            if (clses.size() == this.initialSelection.size()) {
                this.classSelectorPanel = new OWLClassSelectorPanel(this.owlEditorKit);
                this.classSelectorPanel.setSelection(clses);
            }
            this.expressionEditor.setText(this.generateListText());
        }
        if (this.classSelectorPanel != null) {
            this.classSelectorPanel.addSelectionListener(this.changeListener);
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add("Class hierarchy", this.classSelectorPanel);
            this.tabbedPane.add("Expression editor", holderPanel);
            this.tabbedPane.addChangeListener(this.changeListener);
            this.editorComponent.add((Component)this.tabbedPane, "Center");
        } else {
            this.editorComponent.add((Component)holderPanel, "Center");
        }
    }

    private String generateListText() {
        StringBuilder sb = new StringBuilder();
        for (OWLClassExpression c : this.initialSelection) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.owlEditorKit.getModelManager().getRendering((OWLObject)c));
        }
        return sb.toString();
    }

    private Set<OWLClass> getNamedClassesFromInitialSelection() {
        HashSet<OWLClass> clses = new HashSet<OWLClass>();
        if (this.initialSelection != null) {
            for (OWLClassExpression descr : this.initialSelection) {
                if (descr.isAnonymous()) continue;
                clses.add(descr.asOWLClass());
            }
        }
        return clses;
    }

    @Override
    public String getEditorTypeName() {
        return "Set of OWL Class Expressions";
    }

    @Override
    public boolean canEdit(Object object) {
        return this.checkSet(object, OWLClassExpression.class);
    }

    @Override
    public JComponent getEditorComponent() {
        this.ensureEditorExists();
        return this.editorComponent;
    }

    private void ensureEditorExists() {
        if (this.editorComponent == null) {
            this.createEditor();
        }
    }

    @Override
    public Set<OWLClassExpression> getEditedObject() {
        this.ensureEditorExists();
        if (this.tabbedPane != null && this.tabbedPane.getSelectedComponent().equals(this.classSelectorPanel)) {
            return new HashSet<OWLClass>(this.classSelectorPanel.getSelectedObjects());
        }
        try {
            return this.expressionEditor.createObject();
        }
        catch (OWLException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public boolean setEditedObject(Set<OWLClassExpression> expressions) {
        if (expressions == null) {
            expressions = Collections.emptySet();
        }
        this.ensureEditorExists();
        this.expressionEditor.setExpressionObject(expressions);
        if (this.containsOnlyNamedClasses(expressions)) {
            HashSet<OWLClass> clses = new HashSet<OWLClass>(expressions.size());
            for (OWLClassExpression oWLClassExpression : expressions) {
                clses.add(oWLClassExpression.asOWLClass());
            }
            this.classSelectorPanel.setSelection((Set<OWLClass>)clses);
        }
        return true;
    }

    private boolean containsOnlyNamedClasses(Set<OWLClassExpression> expressions) {
        if (expressions != null) {
            for (OWLClassExpression expr : expressions) {
                if (!expr.isAnonymous()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        if (this.classSelectorPanel != null) {
            this.classSelectorPanel.dispose();
        }
    }

    private boolean isValid() {
        if (this.tabbedPane != null && this.tabbedPane.getSelectedComponent().equals(this.classSelectorPanel)) {
            return this.classSelectorPanel.getSelectedObject() != null;
        }
        return this.expressionEditor.isWellFormed();
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        this.expressionEditor.addStatusChangedListener(listener);
        listener.verifiedStatusChanged(this.isValid());
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
        this.expressionEditor.removeStatusChangedListener(listener);
    }
}

