/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLConstantEditor;
import org.protege.editor.owl.ui.frame.OWLDataPropertyConstantPair;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDataPropertyRelationshipEditor
extends AbstractOWLObjectEditor<OWLDataPropertyConstantPair>
implements VerifiedInputEditor {
    private OWLConstantEditor constantEditorComponent;
    private OWLDataPropertySelectorPanel dataPropertySelectorPanel;
    private JPanel componentHolder;
    private List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();
    private boolean currentStatus = false;
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent event) {
            OWLDataPropertyRelationshipEditor.this.checkStatus();
        }
    };

    public OWLDataPropertyRelationshipEditor(OWLEditorKit owlEditorKit) {
        Border paddingBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.dataPropertySelectorPanel = new OWLDataPropertySelectorPanel(owlEditorKit);
        this.dataPropertySelectorPanel.setBorder(BorderFactory.createCompoundBorder(paddingBorder, BorderFactory.createTitledBorder("Data Property")));
        this.dataPropertySelectorPanel.addSelectionListener(this.changeListener);
        this.constantEditorComponent = new OWLConstantEditor(owlEditorKit);
        this.constantEditorComponent.setBorder(paddingBorder);
        this.componentHolder = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(this.dataPropertySelectorPanel);
        splitPane.setRightComponent(this.constantEditorComponent);
        this.componentHolder.add(splitPane);
    }

    public void setDataPropertyAxiom(OWLPropertyAssertionAxiom<OWLDataPropertyExpression, OWLLiteral> ax) {
        OWLDataPropertyExpression p = (OWLDataPropertyExpression)ax.getProperty();
        if (p instanceof OWLDataProperty) {
            this.dataPropertySelectorPanel.setSelection((OWLDataProperty)p);
        }
        this.constantEditorComponent.setEditedObject((OWLLiteral)ax.getObject());
    }

    @Override
    public String getEditorTypeName() {
        return "Data property assertion";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLDataPropertyConstantPair;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.componentHolder;
    }

    @Override
    public OWLDataPropertyConstantPair getEditedObject() {
        OWLDataProperty prop = this.dataPropertySelectorPanel.getSelectedObject();
        if (prop == null) {
            return null;
        }
        OWLLiteral con = this.constantEditorComponent.getEditedObject();
        if (con == null) {
            return null;
        }
        return new OWLDataPropertyConstantPair(prop, con);
    }

    @Override
    public boolean setEditedObject(OWLDataPropertyConstantPair editedObject) {
        if (editedObject == null) {
            this.constantEditorComponent.setEditedObject(null);
        } else {
            this.dataPropertySelectorPanel.setSelection(editedObject.getProperty());
            this.constantEditorComponent.setEditedObject(editedObject.getConstant());
        }
        return true;
    }

    @Override
    public void dispose() {
        this.dataPropertySelectorPanel.dispose();
        this.listeners.clear();
    }

    private void checkStatus() {
        boolean status;
        boolean bl = status = this.dataPropertySelectorPanel.getSelectedObject() != null && this.constantEditorComponent.getEditedObject() != null;
        if (status != this.currentStatus) {
            this.currentStatus = status;
            for (InputVerificationStatusChangedListener l : this.listeners) {
                l.verifiedStatusChanged(this.currentStatus);
            }
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        listener.verifiedStatusChanged(this.currentStatus);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }
}

