/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLGeneralAxiomEditor
extends AbstractOWLObjectEditor<OWLClassAxiom>
implements VerifiedInputEditor {
    private OWLEditorKit editorKit;
    private ExpressionEditor<OWLClassAxiom> editor;
    private JComponent editingComponent;

    public OWLGeneralAxiomEditor(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.editor = new ExpressionEditor<OWLClassAxiom>(editorKit, editorKit.getModelManager().getOWLExpressionCheckerFactory().getClassAxiomChecker());
        this.editingComponent = new JPanel(new BorderLayout());
        this.editingComponent.add(this.editor);
        this.editingComponent.setPreferredSize(new Dimension(400, 200));
    }

    @Override
    public boolean setEditedObject(OWLClassAxiom axiom) {
        if (axiom == null) {
            this.editor.setText("");
        } else {
            this.editor.setText(this.editorKit.getModelManager().getRendering((OWLObject)axiom));
        }
        return true;
    }

    public JComponent getInlineEditorComponent() {
        return this.editingComponent;
    }

    @Override
    public String getEditorTypeName() {
        return "Class Axiom";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLClassAxiom;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editingComponent;
    }

    @Override
    public OWLClassAxiom getEditedObject() {
        try {
            if (this.editor.isWellFormed()) {
                return this.editor.createObject();
            }
            return null;
        }
        catch (OWLException e) {
            return null;
        }
    }

    @Override
    public void dispose() {
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.addStatusChangedListener(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.removeStatusChangedListener(listener);
    }
}

