/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLIndividualSelectorPanel;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIndividualSetEditor
extends AbstractOWLObjectEditor<Set<OWLNamedIndividual>>
implements VerifiedInputEditor {
    private OWLIndividualSelectorPanel panel;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private InputVerificationStatusChangedListener inputListener = new InputVerificationStatusChangedListener(){

        public void verifiedStatusChanged(boolean newState) {
            OWLIndividualSetEditor.this.handleVerifyEditorContents();
        }
    };

    public OWLIndividualSetEditor(OWLEditorKit owlEditorKit) {
        this.panel = new OWLIndividualSelectorPanel(owlEditorKit, 2);
        this.panel.addStatusChangedListener(this.inputListener);
    }

    @Override
    public Set<OWLNamedIndividual> getEditedObject() {
        return this.panel.getSelectedObjects();
    }

    @Override
    public boolean setEditedObject(Set<OWLNamedIndividual> individuals) {
        this.panel.setSelection(individuals != null ? individuals : Collections.EMPTY_SET);
        return true;
    }

    @Override
    public String getEditorTypeName() {
        return "Set of named Individuals";
    }

    @Override
    public boolean canEdit(Object object) {
        return this.checkSet(object, OWLNamedIndividual.class);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.panel;
    }

    private void handleVerifyEditorContents() {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(true);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.add(l);
        l.verifiedStatusChanged(true);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void dispose() {
        this.panel.dispose();
    }
}

