/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectPropertyExpressionEditor
extends AbstractOWLObjectEditor<OWLObjectPropertyExpression>
implements VerifiedInputEditor {
    private JPanel editor;
    private OWLObjectPropertySelectorPanel namedObjectPropertySelector;
    private JCheckBox inverseCheckBox;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private InputVerificationStatusChangedListener inputListener = new InputVerificationStatusChangedListener(){

        public void verifiedStatusChanged(boolean newState) {
            OWLObjectPropertyExpressionEditor.this.handleVerifyEditorContents();
        }
    };

    public OWLObjectPropertyExpressionEditor(OWLEditorKit owlEditorKit) {
        this.editor = new JPanel();
        this.editor.setLayout(new BorderLayout());
        this.namedObjectPropertySelector = new OWLObjectPropertySelectorPanel(owlEditorKit);
        this.namedObjectPropertySelector.addStatusChangedListener(this.inputListener);
        this.editor.add((Component)this.namedObjectPropertySelector, "Center");
        this.inverseCheckBox = new JCheckBox("Inverse Property");
        this.inverseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OWLObjectPropertyExpressionEditor.this.handleVerifyEditorContents();
            }
        });
        this.editor.add((Component)this.inverseCheckBox, "South");
    }

    @Override
    public OWLObjectPropertyExpression getEditedObject() {
        OWLObjectProperty p = this.namedObjectPropertySelector.getSelectedObject();
        return this.inverseCheckBox.isSelected() ? p.getInverseProperty() : p;
    }

    @Override
    public boolean setEditedObject(OWLObjectPropertyExpression p) {
        this.inverseCheckBox.setSelected(p != null ? p.getSimplified().isAnonymous() : false);
        this.namedObjectPropertySelector.setSelection(p != null ? p.getNamedProperty() : null);
        return true;
    }

    @Override
    public String getEditorTypeName() {
        return "Object property";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLObjectPropertyExpression;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editor;
    }

    private void handleVerifyEditorContents() {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(true);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.add(l);
        l.verifiedStatusChanged(true);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void dispose() {
        this.namedObjectPropertySelector.dispose();
    }
}

