/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.Dimension;
import java.util.Set;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectPropertySetEditor
extends AbstractOWLObjectEditor<Set<OWLObjectPropertyExpression>>
implements VerifiedInputEditor {
    private ExpressionEditor<Set<OWLObjectPropertyExpression>> editor;

    public OWLObjectPropertySetEditor(OWLEditorKit eKit) {
        OWLExpressionChecker<Set<OWLObjectPropertyExpression>> checker = eKit.getModelManager().getOWLExpressionCheckerFactory().getObjectPropertySetChecker();
        this.editor = new ExpressionEditor<Set<OWLObjectPropertyExpression>>(eKit, checker);
        this.editor.setPreferredSize(new Dimension(300, 200));
    }

    @Override
    public String getEditorTypeName() {
        return "Set of properties";
    }

    @Override
    public boolean canEdit(Object object) {
        return this.checkSet(object, OWLPropertyExpression.class);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editor;
    }

    @Override
    public Set<OWLObjectPropertyExpression> getEditedObject() {
        try {
            return this.editor.createObject();
        }
        catch (OWLException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean setEditedObject(Set<OWLObjectPropertyExpression> editedObject) {
        this.editor.setExpressionObject(editedObject);
        return true;
    }

    @Override
    public void dispose() {
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.addStatusChangedListener(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.removeStatusChangedListener(listener);
    }
}

