/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.explanation.ExplanationResult;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplanationDialog
extends JDialog {
    private static final long serialVersionUID = -4476549896762790748L;
    public static final String PREFERENCES_SET_KEY = "EXPLANATION_PREFS_SET";
    public static final String DEFAULT_EXPLANATION_ID = "PREFERRED_PLUGIN_ID";
    private JPanel explanationContainer;
    private ExplanationResult explanation;
    private OWLAxiom axiom;

    public ExplanationDialog(Frame owner, ExplanationManager explanationManager, OWLAxiom axiom) {
        super(owner, "Explanation for " + explanationManager.getModelManager().getRendering((OWLObject)axiom));
        this.setModal(false);
        this.axiom = axiom;
        this.setLayout(new BorderLayout());
        Collection<ExplanationService> teachers = explanationManager.getTeachers(axiom);
        if (teachers.size() == 1) {
            this.explanation = teachers.iterator().next().explain(axiom);
        } else {
            JComboBox selector = this.createComboBox(teachers);
            this.add((Component)selector, "North");
        }
        this.explanationContainer = new JPanel();
        this.explanationContainer.setLayout(new BoxLayout(this.explanationContainer, 1));
        this.explanationContainer.add(this.explanation);
        this.add((Component)this.explanationContainer, "Center");
        this.add((Component)this.createButtons(), "South");
        this.pack();
    }

    private JComboBox createComboBox(Collection<ExplanationService> teachers) {
        ExplanationService[] teacherArray = teachers.toArray(new ExplanationService[0]);
        final JComboBox<ExplanationService> selector = new JComboBox<ExplanationService>(teacherArray);
        ExplanationService selected = teacherArray[0];
        String id = this.getDefaultPluginId();
        if (id != null) {
            for (ExplanationService t : teachers) {
                if (!id.equals(t.getPluginId())) continue;
                selected = t;
            }
        }
        selector.setSelectedItem(selected);
        this.explanation = selected.explain(this.axiom);
        selector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationService t = (ExplanationService)selector.getSelectedItem();
                ExplanationDialog.this.setDefaultPluginId(t.getPluginId());
                ExplanationDialog.this.explanationContainer.removeAll();
                if (ExplanationDialog.this.explanation != null) {
                    ExplanationDialog.this.explanation.dispose();
                }
                ExplanationDialog.this.explanation = t.explain(ExplanationDialog.this.axiom);
                ExplanationDialog.this.explanationContainer.add(ExplanationDialog.this.explanation);
                ExplanationDialog.this.pack();
                ExplanationDialog.this.repaint();
            }
        });
        return selector;
    }

    private JComponent createButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationDialog.this.dispose();
            }
        });
        ok.setAlignmentX(0.5f);
        panel.add(ok);
        return panel;
    }

    public String getDefaultPluginId() {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        Preferences prefs = prefMan.getPreferencesForSet(PREFERENCES_SET_KEY, ReasonerPreferences.class);
        return prefs.getString(DEFAULT_EXPLANATION_ID, null);
    }

    public void setDefaultPluginId(String id) {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        Preferences prefs = prefMan.getPreferencesForSet(PREFERENCES_SET_KEY, ReasonerPreferences.class);
        prefs.putString(DEFAULT_EXPLANATION_ID, id);
    }

    @Override
    public void dispose() {
        if (this.explanation != null) {
            this.explanation.dispose();
        }
        super.dispose();
    }
}

