/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation;

import java.awt.Frame;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.explanation.ExplanationDialog;
import org.protege.editor.owl.ui.explanation.ExplanationPlugin;
import org.protege.editor.owl.ui.explanation.ExplanationPluginLoader;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.semanticweb.owlapi.model.OWLAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplanationManager {
    private static Logger logger = Logger.getLogger(ExplanationManager.class);
    private OWLEditorKit editorKit;
    private Collection<ExplanationService> explainers = new HashSet<ExplanationService>();

    public ExplanationManager(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.reload();
    }

    public void reload() {
        ExplanationPluginLoader loader = new ExplanationPluginLoader(this.editorKit);
        this.explainers.clear();
        for (ExplanationPlugin plugin : loader.getPlugins()) {
            ExplanationService teacher = null;
            try {
                teacher = plugin.newInstance();
                teacher.initialise();
                this.explainers.add(teacher);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception caught initialising explanation service " + plugin.getName() + " - skipping..."), (Throwable)e);
            }
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.editorKit;
    }

    public OWLModelManager getModelManager() {
        return this.editorKit.getModelManager();
    }

    public Collection<ExplanationService> getExplainers() {
        return this.explainers;
    }

    public Collection<ExplanationService> getTeachers(OWLAxiom axiom) {
        HashSet<ExplanationService> smartTeachers = new HashSet<ExplanationService>();
        for (ExplanationService teacher : this.explainers) {
            if (!teacher.hasExplanation(axiom)) continue;
            smartTeachers.add(teacher);
        }
        return smartTeachers;
    }

    public boolean hasExplanation(OWLAxiom axiom) {
        for (ExplanationService teacher : this.explainers) {
            if (!teacher.hasExplanation(axiom)) continue;
            return true;
        }
        return false;
    }

    public void handleExplain(Frame owner, OWLAxiom axiom) {
        Collection<ExplanationService> teachers = this.getTeachers(axiom);
        ExplanationDialog explanation = new ExplanationDialog(owner, this, axiom);
        explanation.setVisible(true);
    }
}

