/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation.impl;

import java.util.UUID;
import org.semanticweb.owlapi.debugging.DebuggerClassExpressionGenerator;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class BasicClassExpressionGenerator
extends DebuggerClassExpressionGenerator {
    private OWLDataFactory factory;
    private OWLClassExpression desc;

    public BasicClassExpressionGenerator(OWLDataFactory factory) {
        super(factory);
        this.factory = factory;
    }

    public OWLClassExpression getDebuggerClassExpression() {
        if (this.desc != null) {
            return this.desc;
        }
        return super.getDebuggerClassExpression();
    }

    protected OWLDataFactory getOWLDataFactory() {
        return this.factory;
    }

    protected OWLNamedIndividual getSkolemVariable() {
        return this.factory.getOWLNamedIndividual(IRI.create((String)("http://debug.com/#" + UUID.randomUUID().toString().replace('-', '_'))));
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        OWLObjectPropertyExpression p = axiom.getFirstProperty();
        OWLObjectInverseOf q = this.factory.getOWLObjectInverseOf(axiom.getSecondProperty());
        OWLNamedIndividual i = this.getSkolemVariable();
        OWLObjectHasValue someP = this.factory.getOWLObjectHasValue(p, (OWLIndividual)i);
        OWLObjectHasValue someQ = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)q, (OWLIndividual)i);
        this.desc = this.factory.getOWLObjectUnionOf(new OWLClassExpression[]{this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{someP, this.factory.getOWLObjectComplementOf((OWLClassExpression)someQ)}), this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{someQ, this.factory.getOWLObjectComplementOf((OWLClassExpression)someP)})});
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.desc = this.factory.getOWLObjectIntersectionOf(axiom.getClassesInSignature().toArray(new OWLClassExpression[2]));
        }
    }
}

