/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation.io;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.explanation.io.InconsistentOntologyPlugin;
import org.protege.editor.owl.ui.explanation.io.InconsistentOntologyPluginLoader;

public class IntroductoryPanel
extends JPanel {
    private static final long serialVersionUID = 2168617534333064174L;
    public static final Logger LOGGER = Logger.getLogger(IntroductoryPanel.class);
    private InconsistentOntologyPlugin selectedPlugin;

    public IntroductoryPanel(OWLEditorKit owlEditorKit, InconsistentOntologyPlugin lastSelectedPlugin) throws IOException {
        this.setLayout(new BorderLayout());
        this.add(this.createCenterPanel(owlEditorKit, lastSelectedPlugin));
    }

    private JPanel createCenterPanel(OWLEditorKit owlEditorKit, InconsistentOntologyPlugin lastSelectedPlugin) throws IOException {
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 3));
        JTextPane tp = new JTextPane();
        tp.setEditable(false);
        URL help = this.getClass().getResource("InconsistentOntologyHelp.html");
        tp.setPage(help);
        Font font = UIManager.getFont("TextArea.font");
        if (font != null) {
            String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
            ((HTMLDocument)tp.getDocument()).getStyleSheet().addRule(bodyRule);
        }
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(tp);
        scrollPane.setPreferredSize(new Dimension(480, 300));
        center.add(scrollPane);
        InconsistentOntologyPluginLoader loader = new InconsistentOntologyPluginLoader(owlEditorKit);
        Set plugins = loader.getPlugins();
        if (plugins.size() > 1) {
            Box optBox = new Box(1);
            optBox.setAlignmentX(0.0f);
            optBox.setBorder(ComponentFactory.createTitledBorder((String)"Explanation Plugins"));
            ButtonGroup group = new ButtonGroup();
            boolean selectedOne = false;
            for (final InconsistentOntologyPlugin plugin : plugins) {
                JRadioButton button = new JRadioButton(plugin.getName());
                if (!selectedOne) {
                    button.setSelected(true);
                    selectedOne = true;
                    this.selectedPlugin = plugin;
                }
                if (lastSelectedPlugin != null && plugin.getName().equals(lastSelectedPlugin.getName())) {
                    button.setSelected(true);
                    this.selectedPlugin = plugin;
                }
                group.add(button);
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        IntroductoryPanel.this.selectedPlugin = plugin;
                    }
                });
                optBox.add(button);
            }
            center.add(optBox);
        } else {
            this.selectedPlugin = (InconsistentOntologyPlugin)((Object)plugins.iterator().next());
        }
        return center;
    }

    public InconsistentOntologyPlugin getSelectedPlugin() {
        return this.selectedPlugin;
    }
}

