/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameListener;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.semanticweb.owlapi.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOWLFrame<R>
implements OWLFrame<R> {
    private static final Logger logger = Logger.getLogger(AbstractOWLFrame.class);
    private R rootObject;
    private OWLOntologyManager owlOntologyManager;
    private List<OWLFrameListener> listeners;
    private List<OWLFrameSection> sections;

    public AbstractOWLFrame(OWLOntologyManager owlOntologyManager) {
        this.owlOntologyManager = owlOntologyManager;
        this.listeners = new ArrayList<OWLFrameListener>();
        this.sections = new ArrayList<OWLFrameSection>();
    }

    protected void addSection(OWLFrameSection<? extends Object, ? extends Object, ? extends Object> section, int index) {
        this.sections.add(index, section);
    }

    protected int getSectionCount() {
        return this.sections.size();
    }

    protected void addSection(OWLFrameSection<? extends Object, ? extends Object, ? extends Object> section) {
        this.sections.add(section);
    }

    protected void clearSections() {
        this.sections.clear();
        this.fireContentChanged();
    }

    @Override
    public void dispose() {
        for (OWLFrameSection section : this.sections) {
            section.dispose();
        }
    }

    @Override
    public List<OWLFrameSection> getFrameSections() {
        return this.sections;
    }

    @Override
    public R getRootObject() {
        return this.rootObject;
    }

    protected OWLOntologyManager getManager() {
        return this.owlOntologyManager;
    }

    @Override
    public void setRootObject(R rootObject) {
        this.rootObject = rootObject;
        this.refill();
        this.fireContentChanged();
    }

    public void refill() {
        for (OWLFrameSection section : this.getFrameSections()) {
            try {
                section.setRootObject(this.rootObject);
            }
            catch (Exception ex) {
                ProtegeApplication.getErrorLog().logError((Throwable)ex);
            }
        }
    }

    @Override
    public void addFrameListener(OWLFrameListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFrameListener(OWLFrameListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireContentChanged() {
        for (OWLFrameListener listener : this.listeners) {
            try {
                listener.frameContentChanged();
            }
            catch (Exception e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRootObject());
        sb.append("\n\n");
        for (OWLFrameSection sec : this.getFrameSections()) {
            sb.append(sec.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

