/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerRuntimeException;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOWLFrameSection<R, A extends OWLAxiom, E>
extends OWLAxiomVisitorAdapter
implements OWLFrameSection<R, A, E>,
OWLObjectEditorHandler<E> {
    public static final Logger LOGGER = Logger.getLogger(AbstractOWLFrameSection.class);
    private static int inconsistentOntologyWarnings = 0;
    private OWLEditorKit owlEditorKit;
    private OWLFrame<? extends R> frame;
    private List<OWLFrameSectionRow<R, A, E>> rows;
    private String label;
    private String rowLabel;
    private OWLObjectEditor<E> editor;
    private boolean cacheEditor = true;
    private OWLOntologyChangeListener listener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            AbstractOWLFrameSection.this.handleChanges(changes);
        }
    };

    protected AbstractOWLFrameSection(OWLEditorKit editorKit, String label, String rowLabel, OWLFrame<? extends R> frame) {
        this.owlEditorKit = editorKit;
        this.label = label;
        this.rowLabel = rowLabel;
        this.frame = frame;
        this.rows = new ArrayList<OWLFrameSectionRow<R, A, E>>();
        this.getOWLModelManager().addOntologyChangeListener(this.listener);
    }

    protected AbstractOWLFrameSection(OWLEditorKit editorKit, String label, OWLFrame<? extends R> frame) {
        this(editorKit, label, null, frame);
    }

    protected void setCacheEditor(boolean cacheEditor) {
        this.cacheEditor = cacheEditor;
    }

    public List<MListButton> getAdditionalButtons() {
        return Collections.emptyList();
    }

    protected void handleChanges(List<? extends OWLOntologyChange> changes) {
        if (this.getRootObject() == null) {
            return;
        }
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            oWLOntologyChange.getAxiom().accept((OWLAxiomVisitor)this);
        }
    }

    @Override
    public final void dispose() {
        this.getOWLModelManager().removeOntologyChangeListener(this.listener);
        this.disposeOfSection();
        if (this.editor != null) {
            this.editor.dispose();
        }
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected OWLReasoner getReasoner() {
        return this.getOWLModelManager().getReasoner();
    }

    protected void disposeOfSection() {
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getRowLabel(OWLFrameSectionRow row) {
        return this.rowLabel;
    }

    @Override
    public final OWLObjectEditor<E> getEditor() {
        if (!this.cacheEditor && this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.editor == null) {
            OWLObjectEditor<E> ed = this.getObjectEditor();
            if (ed != null) {
                ed.setHandler(this);
            }
            if (ed instanceof Wizard) {
                return ed;
            }
            this.editor = ed;
        }
        if (this.editor != null) {
            this.editor.clear();
        }
        return this.editor;
    }

    @Override
    public void handleEditingFinished(Set<E> editedObjects) {
        if (editedObjects == null) {
            return;
        }
        HashSet<A> axioms = new HashSet<A>();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (E editedObject : editedObjects) {
            A ax = this.createAxiom(editedObject);
            changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), ax));
            axioms.add(ax);
        }
        this.getOWLModelManager().applyChanges(changes);
        for (OWLAxiom axiom : axioms) {
            if (this.getOWLModelManager().getActiveOntology().containsAxiom(axiom)) continue;
            LOGGER.warn((Object)("axiom not added = " + axiom));
        }
    }

    protected abstract A createAxiom(E var1);

    public abstract OWLObjectEditor<E> getObjectEditor();

    @Override
    public boolean checkEditorResults(OWLObjectEditor<E> editor) {
        return true;
    }

    @Override
    public int getRowIndex(OWLFrameSectionRow row) {
        return this.rows.indexOf(row);
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.getOWLModelManager().getOWLOntologyManager();
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.getOWLModelManager().getOWLDataFactory();
    }

    public OWLReasoner getCurrentReasoner() {
        return this.getOWLModelManager().getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public OWLFrame<? extends R> getFrame() {
        return this.frame;
    }

    @Override
    public R getRootObject() {
        return this.frame.getRootObject();
    }

    @Override
    public void setRootObject(R rootObject) {
        Comparator comparator;
        this.rows.clear();
        this.clear();
        if (rootObject != null) {
            for (OWLOntology ontology : this.getOntologies()) {
                this.refill(ontology);
            }
            try {
                this.refillInferred();
            }
            catch (InconsistentOntologyException ioe) {
                if (++inconsistentOntologyWarnings % 5 == 0) {
                    ProtegeApplication.getErrorLog().logError((Throwable)ioe);
                } else {
                    LOGGER.warn((Object)("Ontology is inconsistent: " + (Object)((Object)ioe)));
                }
            }
            catch (OWLReasonerRuntimeException e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
        }
        if ((comparator = this.getRowComparator()) != null) {
            Collections.sort(this.rows, comparator);
        }
        this.fireContentChanged();
    }

    protected Set<OWLOntology> getOntologies() {
        return this.getOWLModelManager().getActiveOntologies();
    }

    protected abstract void refill(OWLOntology var1);

    protected abstract void clear();

    protected void refillInferred() {
    }

    protected void addRow(OWLFrameSectionRow<R, A, E> row) {
        this.rows.add(row);
    }

    protected void reset() {
        this.setRootObject(this.getRootObject());
        this.fireContentChanged();
    }

    private void fireContentChanged() {
        this.getFrame().fireContentChanged();
    }

    @Override
    public List<OWLFrameSectionRow<R, A, E>> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    @Override
    public List<A> getAxioms() {
        ArrayList<A> axioms = new ArrayList<A>();
        for (OWLFrameSectionRow<R, A, E> row : this.rows) {
            axioms.add(row.getAxiom());
        }
        return axioms;
    }

    public String getRendering() {
        return this.label;
    }

    public boolean canAdd() {
        return this.getOWLModelManager().isActiveOntologyMutable();
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        return false;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRendering());
        sb.append(":\n");
        for (OWLFrameSectionRow<R, A, E> row : this.getRows()) {
            sb.append("\t");
            sb.append(row);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getName() {
        return this.getLabel();
    }
}

