/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.editor.OWLAnnotationEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLAnnotationsFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAnnotationFrameSection
extends AbstractOWLFrameSection<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation> {
    private static final String LABEL = "Annotations";
    private static OWLAnnotationSectionRowComparator comparator;

    public OWLAnnotationFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLAnnotationSubject> frame) {
        super(editorKit, LABEL, "Entity annotation", frame);
        comparator = new OWLAnnotationSectionRowComparator(editorKit.getModelManager());
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        boolean hidden = false;
        OWLAnnotationSubject annotationSubject = (OWLAnnotationSubject)this.getRootObject();
        for (OWLAnnotationAssertionAxiom ax : ontology.getAnnotationAssertionAxioms(annotationSubject)) {
            if (!this.getOWLEditorKit().getWorkspace().isHiddenAnnotationURI(ax.getAnnotation().getProperty().getIRI().toURI())) {
                this.addRow(new OWLAnnotationsFrameSectionRow(this.getOWLEditorKit(), this, ontology, annotationSubject, ax));
                continue;
            }
            hidden = true;
        }
        if (hidden) {
            this.setLabel("Annotations (some annotations are hidden)");
        } else {
            this.setLabel(LABEL);
        }
    }

    @Override
    protected OWLAnnotationAssertionAxiom createAxiom(OWLAnnotation object) {
        return this.getOWLDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)this.getRootObject(), object);
    }

    @Override
    public OWLObjectEditor<OWLAnnotation> getObjectEditor() {
        return new OWLAnnotationEditor(this.getOWLEditorKit());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation>> getRowComparator() {
        return comparator;
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLAnnotation) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLAnnotation) {
                OWLAnnotation annot = (OWLAnnotation)obj;
                OWLAnnotationAssertionAxiom ax = this.getOWLDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)this.getRootObject(), annot);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        OWLAnnotationSubject root = (OWLAnnotationSubject)this.getRootObject();
        if (axiom.getSubject().equals(root)) {
            this.reset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OWLAnnotationSectionRowComparator
    implements Comparator<OWLFrameSectionRow<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation>> {
        private Comparator<OWLObject> owlObjectComparator;

        public OWLAnnotationSectionRowComparator(OWLModelManager owlModelManager) {
            this.owlObjectComparator = owlModelManager.getOWLObjectComparator();
        }

        @Override
        public int compare(OWLFrameSectionRow<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation> o1, OWLFrameSectionRow<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation> o2) {
            return this.owlObjectComparator.compare((OWLObject)o1.getAxiom(), (OWLObject)o2.getAxiom());
        }
    }
}

