/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.ArrayList;
import java.util.List;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.frame.AbstractOWLFrame;
import org.protege.editor.owl.ui.frame.InferredAxiomsFrameSection;
import org.protege.editor.owl.ui.frame.OWLAnnotationFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.cls.OWLClassAssertionAxiomMembersSection;
import org.protege.editor.owl.ui.frame.cls.OWLDisjointClassesAxiomFrameSection;
import org.protege.editor.owl.ui.frame.cls.OWLDisjointUnionAxiomFrameSection;
import org.protege.editor.owl.ui.frame.cls.OWLEquivalentClassesAxiomFrameSection;
import org.protege.editor.owl.ui.frame.cls.OWLSubClassAxiomFrameSection;
import org.protege.editor.owl.ui.frame.dataproperty.OWLDataPropertyDomainFrameSection;
import org.protege.editor.owl.ui.frame.dataproperty.OWLDataPropertyRangeFrameSection;
import org.protege.editor.owl.ui.frame.dataproperty.OWLDisjointDataPropertiesFrameSection;
import org.protege.editor.owl.ui.frame.dataproperty.OWLEquivalentDataPropertiesFrameSection;
import org.protege.editor.owl.ui.frame.dataproperty.OWLSubDataPropertyAxiomSuperPropertyFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLClassAssertionAxiomTypeFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLDataPropertyAssertionAxiomFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLDifferentIndividualsAxiomFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLNegativeDataPropertyAssertionFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLNegativeObjectPropertyAssertionFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLObjectPropertyAssertionAxiomFrameSection;
import org.protege.editor.owl.ui.frame.individual.OWLSameIndividualsAxiomFrameSection;
import org.protege.editor.owl.ui.frame.objectproperty.OWLDisjointObjectPropertiesFrameSection;
import org.protege.editor.owl.ui.frame.objectproperty.OWLEquivalentObjectPropertiesAxiomFrameSection;
import org.protege.editor.owl.ui.frame.objectproperty.OWLObjectPropertyDomainFrameSection;
import org.protege.editor.owl.ui.frame.objectproperty.OWLObjectPropertyRangeFrameSection;
import org.protege.editor.owl.ui.frame.objectproperty.OWLPropertyChainAxiomFrameSection;
import org.protege.editor.owl.ui.frame.objectproperty.OWLSubObjectPropertyAxiomSuperPropertyFrameSection;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityFrame
extends AbstractOWLFrame
implements OWLEntityVisitor {
    private OWLEditorKit editorKit;
    private List<OWLFrameSection> owlOntologyFrameSections;
    private List<OWLFrameSection> owlClassSections;
    private List<OWLFrameSection> owlObjectPropertySections;
    private List<OWLFrameSection> owlDataPropertySections;
    private List<OWLFrameSection> owlAnnotationPropertySections;
    private List<OWLFrameSection> owlIndividualSections;
    private OWLModelManagerListener owlModelManagerListener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.ONTOLOGY_CLASSIFIED)) {
                OWLEntityFrame.this.refill();
                OWLEntityFrame.this.setRootObject((OWLObject)OWLEntityFrame.this.editorKit.getModelManager().getActiveOntology());
            }
        }
    };

    public OWLEntityFrame(OWLEditorKit editorKit) {
        super(editorKit.getModelManager().getOWLOntologyManager());
        this.editorKit = editorKit;
        this.owlOntologyFrameSections = new ArrayList<OWLFrameSection>();
        this.owlOntologyFrameSections.add(new InferredAxiomsFrameSection(editorKit, this));
        this.owlClassSections = new ArrayList<OWLFrameSection>();
        this.owlClassSections.add(new OWLAnnotationFrameSection(editorKit, this));
        this.owlClassSections.add(new OWLEquivalentClassesAxiomFrameSection(editorKit, this));
        this.owlClassSections.add(new OWLSubClassAxiomFrameSection(editorKit, this));
        this.owlClassSections.add(new OWLClassAssertionAxiomMembersSection(editorKit, this));
        this.owlClassSections.add(new OWLDisjointClassesAxiomFrameSection(editorKit, this));
        this.owlClassSections.add(new OWLDisjointUnionAxiomFrameSection(editorKit, this));
        this.owlObjectPropertySections = new ArrayList<OWLFrameSection>();
        this.owlObjectPropertySections.add(new OWLAnnotationFrameSection(editorKit, this));
        this.owlObjectPropertySections.add(new OWLObjectPropertyDomainFrameSection(editorKit, this));
        this.owlObjectPropertySections.add(new OWLObjectPropertyRangeFrameSection(editorKit, this));
        this.owlObjectPropertySections.add(new OWLEquivalentObjectPropertiesAxiomFrameSection(editorKit, this));
        this.owlObjectPropertySections.add(new OWLSubObjectPropertyAxiomSuperPropertyFrameSection(editorKit, this));
        this.owlObjectPropertySections.add(new OWLDisjointObjectPropertiesFrameSection(editorKit, this));
        this.owlObjectPropertySections.add(new OWLPropertyChainAxiomFrameSection(editorKit, this));
        this.owlDataPropertySections = new ArrayList<OWLFrameSection>();
        this.owlDataPropertySections.add(new OWLAnnotationFrameSection(editorKit, this));
        this.owlDataPropertySections.add(new OWLDataPropertyDomainFrameSection(editorKit, this));
        this.owlDataPropertySections.add(new OWLDataPropertyRangeFrameSection(editorKit, this));
        this.owlDataPropertySections.add(new OWLEquivalentDataPropertiesFrameSection(editorKit, this));
        this.owlDataPropertySections.add(new OWLSubDataPropertyAxiomSuperPropertyFrameSection(editorKit, this));
        this.owlDataPropertySections.add(new OWLDisjointDataPropertiesFrameSection(editorKit, this));
        this.owlAnnotationPropertySections = new ArrayList<OWLFrameSection>();
        this.owlIndividualSections = new ArrayList<OWLFrameSection>();
        this.owlIndividualSections.add(new OWLAnnotationFrameSection(editorKit, this));
        this.owlIndividualSections.add(new OWLClassAssertionAxiomTypeFrameSection(editorKit, this));
        this.owlIndividualSections.add(new OWLObjectPropertyAssertionAxiomFrameSection(editorKit, this));
        this.owlIndividualSections.add(new OWLNegativeObjectPropertyAssertionFrameSection(editorKit, this));
        this.owlIndividualSections.add(new OWLDataPropertyAssertionAxiomFrameSection(editorKit, this));
        this.owlIndividualSections.add(new OWLNegativeDataPropertyAssertionFrameSection(editorKit, this));
        this.owlIndividualSections.add(new OWLSameIndividualsAxiomFrameSection(editorKit, this));
        this.owlIndividualSections.add(new OWLDifferentIndividualsAxiomFrameSection(editorKit, this));
        this.setRootObject((OWLObject)editorKit.getModelManager().getOWLDataFactory().getOWLThing());
        editorKit.getModelManager().addListener(this.owlModelManagerListener);
    }

    @Override
    public void setRootObject(OWLObject rootObject) {
        this.clearSections();
        if (rootObject != null) {
            if (rootObject instanceof OWLOntology) {
                this.setupSections(this.owlOntologyFrameSections);
            } else {
                ((OWLEntity)rootObject).accept((OWLEntityVisitor)this);
            }
        }
        super.setRootObject(rootObject);
    }

    public void visit(OWLClass owlClass) {
        this.setupSections(this.owlClassSections);
    }

    public void visit(OWLObjectProperty owlObjectProperty) {
        this.setupSections(this.owlObjectPropertySections);
    }

    public void visit(OWLDataProperty owlDataProperty) {
        this.setupSections(this.owlDataPropertySections);
    }

    public void visit(OWLAnnotationProperty owlAnnotationProperty) {
        this.setupSections(this.owlAnnotationPropertySections);
    }

    public void visit(OWLDatatype owlDatatype) {
    }

    public void visit(OWLNamedIndividual owlIndividual) {
        this.setupSections(this.owlIndividualSections);
    }

    private void setupSections(List<OWLFrameSection> sections) {
        for (OWLFrameSection sec : sections) {
            this.addSection(sec);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.editorKit.getModelManager().removeListener(this.owlModelManagerListener);
        this.disposeOfSections(this.owlClassSections);
        this.disposeOfSections(this.owlObjectPropertySections);
        this.disposeOfSections(this.owlDataPropertySections);
        this.disposeOfSections(this.owlAnnotationPropertySections);
        this.disposeOfSections(this.owlIndividualSections);
    }

    private void disposeOfSections(List<OWLFrameSection> sections) {
        for (OWLFrameSection sec : sections) {
            sec.dispose();
        }
    }
}

