/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.annotationproperty;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.IRIFromEntityEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.annotationproperty.OWLAnnotationPropertyRangeFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAnnotationPropertyRangeFrameSection
extends AbstractOWLFrameSection<OWLAnnotationProperty, OWLAnnotationPropertyRangeAxiom, IRI> {
    public static final String LABEL = "Range (intersection)";
    private Set<IRI> addedDomains = new HashSet<IRI>();
    private IRIFromEntityEditor editor;

    public OWLAnnotationPropertyRangeFrameSection(OWLEditorKit editorKit, OWLFrame<OWLAnnotationProperty> frame) {
        super(editorKit, LABEL, "Range", frame);
    }

    @Override
    protected OWLAnnotationPropertyRangeAxiom createAxiom(IRI iri) {
        return this.getOWLDataFactory().getOWLAnnotationPropertyRangeAxiom((OWLAnnotationProperty)this.getRootObject(), iri);
    }

    protected Set<OWLAnnotationPropertyRangeAxiom> getAxioms(OWLOntology ontology) {
        return ontology.getAnnotationPropertyRangeAxioms((OWLAnnotationProperty)this.getRootObject());
    }

    @Override
    public OWLObjectEditor<IRI> getObjectEditor() {
        if (this.editor == null) {
            this.editor = new IRIFromEntityEditor(this.getOWLEditorKit());
        }
        return this.editor;
    }

    @Override
    public final boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)obj;
                OWLAnnotationPropertyRangeAxiom ax = this.createAxiom(entity.getIRI());
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    @Override
    protected void clear() {
        this.addedDomains.clear();
    }

    @Override
    protected final void refill(OWLOntology ontology) {
        for (OWLAnnotationPropertyRangeAxiom ax : this.getAxioms(ontology)) {
            this.addRow(new OWLAnnotationPropertyRangeFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLAnnotationProperty)this.getRootObject(), ax));
            this.addedDomains.add(ax.getRange());
        }
    }

    @Override
    protected final void refillInferred() {
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLAnnotationProperty, OWLAnnotationPropertyRangeAxiom, IRI>> getRowComparator() {
        return null;
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        if (axiom.getProperty().equals(this.getRootObject())) {
            this.reset();
        }
    }
}

