/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.annotationproperty;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLAnnotationPropertyEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.annotationproperty.OWLSubAnnotationPropertyFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLSubAnnotationPropertyFrameSection
extends AbstractOWLFrameSection<OWLAnnotationProperty, OWLSubAnnotationPropertyOfAxiom, OWLAnnotationProperty> {
    public static final String LABEL = "Superproperties";
    private Set<OWLAnnotationProperty> added = new HashSet<OWLAnnotationProperty>();
    private OWLAnnotationPropertyEditor editor;

    public OWLSubAnnotationPropertyFrameSection(OWLEditorKit editorKit, OWLFrame<OWLAnnotationProperty> frame) {
        super(editorKit, LABEL, LABEL, frame);
    }

    @Override
    protected OWLSubAnnotationPropertyOfAxiom createAxiom(OWLAnnotationProperty superProp) {
        return this.getOWLDataFactory().getOWLSubAnnotationPropertyOfAxiom((OWLAnnotationProperty)this.getRootObject(), superProp);
    }

    protected Set<OWLSubAnnotationPropertyOfAxiom> getAxioms(OWLOntology ontology) {
        return ontology.getSubAnnotationPropertyOfAxioms((OWLAnnotationProperty)this.getRootObject());
    }

    @Override
    public OWLObjectEditor<OWLAnnotationProperty> getObjectEditor() {
        if (this.editor == null) {
            this.editor = new OWLAnnotationPropertyEditor(this.getOWLEditorKit());
        }
        return this.editor;
    }

    @Override
    public final boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLAnnotationProperty) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLAnnotationProperty) {
                OWLAnnotationProperty property = (OWLAnnotationProperty)obj;
                OWLSubAnnotationPropertyOfAxiom ax = this.createAxiom(property);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    protected final void refill(OWLOntology ontology) {
        for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxioms(ontology)) {
            this.addRow(new OWLSubAnnotationPropertyFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLAnnotationProperty)this.getRootObject(), ax));
            this.added.add(ax.getSuperProperty());
        }
    }

    @Override
    protected final void refillInferred() {
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLAnnotationProperty, OWLSubAnnotationPropertyOfAxiom, OWLAnnotationProperty>> getRowComparator() {
        return null;
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        if (axiom.getSubProperty().equals(this.getRootObject())) {
            this.reset();
        }
    }
}

