/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.cls;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLClassExpressionSetEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.cls.AbstractOWLClassAxiomFrameSection;
import org.protege.editor.owl.ui.frame.cls.OWLDisjointClassesAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDisjointClassesAxiomFrameSection
extends AbstractOWLClassAxiomFrameSection<OWLDisjointClassesAxiom, Set<OWLClassExpression>> {
    public static final String LABEL = "Disjoint classes";
    public Set<OWLClassExpression> added = new HashSet<OWLClassExpression>();

    public OWLDisjointClassesAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<OWLClass> frame) {
        super(editorKit, LABEL, LABEL, (OWLFrame<? extends OWLClassExpression>)frame);
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    protected void addAxiom(OWLDisjointClassesAxiom ax, OWLOntology ont) {
        this.addRow(new OWLDisjointClassesAxiomFrameSectionRow(this.getOWLEditorKit(), this, ont, this.getRootObject(), ax));
        this.added.addAll(ax.getClassExpressions());
    }

    @Override
    protected Set<OWLDisjointClassesAxiom> getClassAxioms(OWLClassExpression descr, OWLOntology ont) {
        if (!descr.isAnonymous()) {
            return ont.getDisjointClassesAxioms(descr.asOWLClass());
        }
        HashSet<OWLDisjointClassesAxiom> axioms = new HashSet<OWLDisjointClassesAxiom>();
        for (OWLDisjointClassesAxiom ax : ont.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (!ax.getClassExpressions().contains(descr)) continue;
            axioms.add(ax);
        }
        return axioms;
    }

    @Override
    protected OWLDisjointClassesAxiom createAxiom(Set<OWLClassExpression> object) {
        object.add(this.getRootObject());
        return this.getOWLDataFactory().getOWLDisjointClassesAxiom(object);
    }

    @Override
    public OWLObjectEditor<Set<OWLClassExpression>> getObjectEditor() {
        return new OWLClassExpressionSetEditor(this.getOWLEditorKit());
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_DISJOINT_CLASSES, new Runnable(){

            public void run() {
                OWLReasoner reasoner = OWLDisjointClassesAxiomFrameSection.this.getOWLModelManager().getReasoner();
                if (!reasoner.isConsistent()) {
                    return;
                }
                NodeSet disjointFromRoot = reasoner.getSubClasses((OWLClassExpression)OWLDisjointClassesAxiomFrameSection.this.getOWLDataFactory().getOWLObjectComplementOf(OWLDisjointClassesAxiomFrameSection.this.getRootObject()), true);
                for (OWLClass c : disjointFromRoot.getFlattened()) {
                    if (OWLDisjointClassesAxiomFrameSection.this.added.contains(c) || c.equals(OWLDisjointClassesAxiomFrameSection.this.getOWLDataFactory().getOWLNothing()) || c.equals(OWLDisjointClassesAxiomFrameSection.this.getRootObject())) continue;
                    OWLDisjointClassesAxiomFrameSection.this.addRow(new OWLDisjointClassesAxiomFrameSectionRow(OWLDisjointClassesAxiomFrameSection.this.getOWLEditorKit(), OWLDisjointClassesAxiomFrameSection.this, null, OWLDisjointClassesAxiomFrameSection.this.getRootObject(), OWLDisjointClassesAxiomFrameSection.this.getOWLModelManager().getOWLDataFactory().getOWLDisjointClassesAxiom(new OWLClassExpression[]{OWLDisjointClassesAxiomFrameSection.this.getRootObject(), c})));
                    OWLDisjointClassesAxiomFrameSection.this.added.add((OWLClassExpression)c);
                }
            }
        });
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<Set<OWLClassExpression>> editor) {
        Set<OWLClassExpression> disjoints = editor.getEditedObject();
        return disjoints.size() != 1 || !disjoints.contains(this.getRootObject());
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getClassExpressions().contains(this.getRootObject())) {
            this.reset();
        }
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        HashSet<OWLClassExpression> descriptions = new HashSet<OWLClassExpression>();
        descriptions.add(this.getRootObject());
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) {
                OWLClassExpression desc = (OWLClassExpression)obj;
                descriptions.add(desc);
                continue;
            }
            return false;
        }
        if (descriptions.size() > 1) {
            OWLDisjointClassesAxiom ax = this.getOWLDataFactory().getOWLDisjointClassesAxiom(descriptions);
            changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
            this.getOWLModelManager().applyChanges(changes);
        }
        return true;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLClassExpression, OWLDisjointClassesAxiom, Set<OWLClassExpression>>> getRowComparator() {
        return null;
    }
}

