/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.individual;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLIndividualSetEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.individual.OWLSameIndividualsAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLSameIndividualsAxiomFrameSection
extends AbstractOWLFrameSection<OWLNamedIndividual, OWLSameIndividualAxiom, Set<OWLNamedIndividual>> {
    public static final String LABEL = "Same individuals";

    public OWLSameIndividualsAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLNamedIndividual> frame) {
        super(editorKit, LABEL, LABEL, frame);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLSameIndividualAxiom ax : ontology.getSameIndividualAxioms((OWLIndividual)this.getRootObject())) {
            this.addRow(new OWLSameIndividualsAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLNamedIndividual)this.getRootObject(), ax));
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_SAMEAS_INDIVIDUAL_ASSERTIONS, new Runnable(){

            public void run() {
                if (!OWLSameIndividualsAxiomFrameSection.this.getOWLModelManager().getReasoner().isConsistent()) {
                    return;
                }
                Set<OWLIndividual> existingSameIndividuals = OWLSameIndividualsAxiomFrameSection.this.getCurrentlyDisplayedSameIndividuals();
                HashSet<Object> newSameIndividuals = new HashSet<Object>();
                for (OWLNamedIndividual i : OWLSameIndividualsAxiomFrameSection.this.getCurrentReasoner().getSameIndividuals((OWLNamedIndividual)OWLSameIndividualsAxiomFrameSection.this.getRootObject()).getEntities()) {
                    if (i.equals(OWLSameIndividualsAxiomFrameSection.this.getRootObject()) || existingSameIndividuals.contains(i)) continue;
                    newSameIndividuals.add(i);
                }
                if (!newSameIndividuals.isEmpty()) {
                    newSameIndividuals.add(OWLSameIndividualsAxiomFrameSection.this.getRootObject());
                    OWLSameIndividualsAxiomFrameSection.this.addRow(new OWLSameIndividualsAxiomFrameSectionRow(OWLSameIndividualsAxiomFrameSection.this.getOWLEditorKit(), OWLSameIndividualsAxiomFrameSection.this, null, (OWLNamedIndividual)OWLSameIndividualsAxiomFrameSection.this.getRootObject(), OWLSameIndividualsAxiomFrameSection.this.getOWLDataFactory().getOWLSameIndividualAxiom(newSameIndividuals)));
                }
            }
        });
    }

    public Set<OWLIndividual> getCurrentlyDisplayedSameIndividuals() {
        HashSet<OWLIndividual> existingSameIndividuals = new HashSet<OWLIndividual>();
        for (OWLFrameSectionRow existingRow : this.getRows()) {
            OWLSameIndividualAxiom existingAxiom = (OWLSameIndividualAxiom)existingRow.getAxiom();
            for (OWLIndividual existingSameIndividual : existingAxiom.getIndividuals()) {
                existingSameIndividuals.add(existingSameIndividual);
            }
        }
        return existingSameIndividuals;
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        if (axiom.getIndividuals().contains(this.getRootObject())) {
            this.reset();
        }
    }

    @Override
    protected OWLSameIndividualAxiom createAxiom(Set<OWLNamedIndividual> object) {
        object.add((OWLNamedIndividual)this.getRootObject());
        OWLSameIndividualAxiom ax = this.getOWLDataFactory().getOWLSameIndividualAxiom(object);
        return ax;
    }

    @Override
    public OWLObjectEditor<Set<OWLNamedIndividual>> getObjectEditor() {
        return new OWLIndividualSetEditor(this.getOWLEditorKit());
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<Set<OWLNamedIndividual>> editor) {
        Set<OWLNamedIndividual> equivalents = editor.getEditedObject();
        return !equivalents.contains(this.getRootObject());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLNamedIndividual, OWLSameIndividualAxiom, Set<OWLNamedIndividual>>> getRowComparator() {
        return null;
    }
}

