/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.objectproperty;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyExpressionEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.objectproperty.OWLEquivalentObjectPropertiesAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEquivalentObjectPropertiesAxiomFrameSection
extends AbstractOWLFrameSection<OWLObjectProperty, OWLEquivalentObjectPropertiesAxiom, OWLObjectPropertyExpression> {
    public static final String LABEL = "Equivalent object properties";
    private Set<OWLEquivalentObjectPropertiesAxiom> added = new HashSet<OWLEquivalentObjectPropertiesAxiom>();

    public OWLEquivalentObjectPropertiesAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLObjectProperty> frame) {
        super(editorKit, LABEL, "Equivalent object property", frame);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        this.added.clear();
        for (OWLEquivalentObjectPropertiesAxiom ax : ontology.getEquivalentObjectPropertiesAxioms((OWLObjectPropertyExpression)this.getRootObject())) {
            this.addRow(new OWLEquivalentObjectPropertiesAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLObjectProperty)this.getRootObject(), ax));
            this.added.add(ax);
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_EQUIVALENT_OBJECT_PROPERTIES, new Runnable(){

            public void run() {
                if (!OWLEquivalentObjectPropertiesAxiomFrameSection.this.getOWLModelManager().getReasoner().isConsistent()) {
                    return;
                }
                HashSet equivs = new HashSet(OWLEquivalentObjectPropertiesAxiomFrameSection.this.getReasoner().getEquivalentObjectProperties((OWLObjectPropertyExpression)OWLEquivalentObjectPropertiesAxiomFrameSection.this.getRootObject()).getEntities());
                equivs.remove(OWLEquivalentObjectPropertiesAxiomFrameSection.this.getRootObject());
                if (!equivs.isEmpty()) {
                    OWLEquivalentObjectPropertiesAxiom ax = OWLEquivalentObjectPropertiesAxiomFrameSection.this.getOWLDataFactory().getOWLEquivalentObjectPropertiesAxiom(equivs);
                    if (!OWLEquivalentObjectPropertiesAxiomFrameSection.this.added.contains(ax)) {
                        OWLEquivalentObjectPropertiesAxiomFrameSection.this.addRow(new OWLEquivalentObjectPropertiesAxiomFrameSectionRow(OWLEquivalentObjectPropertiesAxiomFrameSection.this.getOWLEditorKit(), OWLEquivalentObjectPropertiesAxiomFrameSection.this, null, (OWLObjectProperty)OWLEquivalentObjectPropertiesAxiomFrameSection.this.getRootObject(), ax));
                    }
                }
            }
        });
    }

    @Override
    protected OWLEquivalentObjectPropertiesAxiom createAxiom(OWLObjectPropertyExpression object) {
        return this.getOWLDataFactory().getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLObjectPropertyExpression[]{(OWLObjectPropertyExpression)this.getRootObject(), object}));
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().contains(this.getRootObject())) {
            this.reset();
        }
    }

    @Override
    public OWLObjectEditor<OWLObjectPropertyExpression> getObjectEditor() {
        return new OWLObjectPropertyExpressionEditor(this.getOWLEditorKit());
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<OWLObjectPropertyExpression> editor) {
        Set<OWLObjectPropertyExpression> equivalents = editor.getEditedObjects();
        return equivalents.size() != 1 || !equivalents.contains(this.getRootObject());
    }

    @Override
    public void handleEditingFinished(Set<OWLObjectPropertyExpression> editedObjects) {
        editedObjects = new HashSet<OWLObjectPropertyExpression>(editedObjects);
        editedObjects.remove(this.getRootObject());
        super.handleEditingFinished(editedObjects);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        if (axiom.getProperties().contains(this.getRootObject())) {
            this.reset();
        }
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLObjectProperty, OWLEquivalentObjectPropertiesAxiom, OWLObjectPropertyExpression>> getRowComparator() {
        return null;
    }
}

