/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.objectproperty;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.objectproperty.OWLInverseObjectPropertiesAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLInverseObjectPropertiesAxiomFrameSection
extends AbstractOWLFrameSection<OWLObjectProperty, OWLInverseObjectPropertiesAxiom, OWLObjectProperty> {
    public static final String LABEL = "Inverse properties";
    private Set<OWLObjectPropertyExpression> added = new HashSet<OWLObjectPropertyExpression>();

    public OWLInverseObjectPropertiesAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLObjectProperty> frame) {
        super(editorKit, LABEL, "Inverse property", frame);
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLInverseObjectPropertiesAxiom ax : ontology.getInverseObjectPropertyAxioms((OWLObjectPropertyExpression)this.getRootObject())) {
            this.addRow(new OWLInverseObjectPropertiesAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLObjectProperty)this.getRootObject(), ax));
            this.added.addAll(ax.getProperties());
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_INVERSE_PROPERTIES, new Runnable(){

            public void run() {
                OWLObjectPropertyExpression invProp;
                if (!OWLInverseObjectPropertiesAxiomFrameSection.this.getOWLModelManager().getReasoner().isConsistent()) {
                    return;
                }
                HashSet infInverses = new HashSet(OWLInverseObjectPropertiesAxiomFrameSection.this.getReasoner().getInverseObjectProperties((OWLObjectPropertyExpression)OWLInverseObjectPropertiesAxiomFrameSection.this.getRootObject()).getEntities());
                infInverses.removeAll(OWLInverseObjectPropertiesAxiomFrameSection.this.added);
                Iterator i$ = infInverses.iterator();
                while (i$.hasNext() && !(invProp = (OWLObjectPropertyExpression)i$.next()).isAnonymous()) {
                    OWLInverseObjectPropertiesAxiom ax = OWLInverseObjectPropertiesAxiomFrameSection.this.getOWLDataFactory().getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)OWLInverseObjectPropertiesAxiomFrameSection.this.getRootObject(), invProp);
                    OWLInverseObjectPropertiesAxiomFrameSection.this.addRow(new OWLInverseObjectPropertiesAxiomFrameSectionRow(OWLInverseObjectPropertiesAxiomFrameSection.this.getOWLEditorKit(), OWLInverseObjectPropertiesAxiomFrameSection.this, null, (OWLObjectProperty)OWLInverseObjectPropertiesAxiomFrameSection.this.getRootObject(), ax));
                }
            }
        });
    }

    @Override
    protected OWLInverseObjectPropertiesAxiom createAxiom(OWLObjectProperty object) {
        return this.getOWLDataFactory().getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)this.getRootObject(), (OWLObjectPropertyExpression)object);
    }

    @Override
    public OWLObjectEditor<OWLObjectProperty> getObjectEditor() {
        return new OWLObjectPropertyEditor(this.getOWLEditorKit());
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().contains(this.getRootObject())) {
            this.reset();
        }
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLObjectProperty, OWLInverseObjectPropertiesAxiom, OWLObjectProperty>> getRowComparator() {
        return null;
    }
}

