/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.framelist;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import org.protege.editor.core.ui.list.MListButton;

public class AxiomAnnotationButton
extends MListButton {
    public static final Color ROLL_OVER_COLOR = new Color(0, 0, 0);
    private static final String ANNOTATE_STRING = "@";
    private boolean annotationPresent = false;

    public AxiomAnnotationButton(ActionListener actionListener) {
        super("Annotations", ROLL_OVER_COLOR, actionListener);
    }

    public void paintButtonContent(Graphics2D g) {
        Font font = g.getFont();
        int w = this.getBounds().width;
        int h = this.getBounds().height;
        int x = this.getBounds().x;
        int y = this.getBounds().y;
        g.setFont(font.deriveFont(1).deriveFont(8));
        Rectangle stringBounds = g.getFontMetrics().getStringBounds(ANNOTATE_STRING, g).getBounds();
        g.drawString(ANNOTATE_STRING, this.getBounds().x + w / 2 - stringBounds.width / 2, this.getBounds().y + h / 2 + stringBounds.height / 2 - 3);
        if (this.annotationPresent) {
            g.drawOval(x + 2, y + 2, w - 4, h - 4);
        }
        g.setFont(font);
    }

    public void setAnnotationPresent(boolean annotationPresent) {
        this.annotationPresent = annotationPresent;
    }
}

