/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.inference;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.JOptionPane;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.reasoner.InferenceType;

public class PrecomputeAction
extends ProtegeOWLAction {
    private static final long serialVersionUID = -4602291778441065461L;
    private OWLModelManagerListener owlModelManagerListener;

    public void actionPerformed(ActionEvent e) {
        Object[] options;
        int ret;
        ReasonerPreferences preferences = this.getOWLModelManager().getOWLReasonerManager().getReasonerPreferences();
        Set<InferenceType> precompute = preferences.getPrecomputedInferences();
        if (!this.getOWLModelManager().getOWLReasonerManager().classifyAsynchronously(precompute) && (ret = JOptionPane.showOptionDialog(null, "Reasoner initialization still in progress.  New initialization can't be started", "Reasoner initialization in progress", 1, 3, null, options = new Object[]{"OK", "Interrupt Current Reasoning Task"}, options[0])) == 1) {
            this.getOWLModelManager().getOWLReasonerManager().killCurrentClassification();
        }
    }

    public void dispose() {
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
    }

    public void initialise() throws Exception {
        this.owlModelManagerListener = new OWLModelManagerListener(){

            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ONTOLOGY_CLASSIFIED)) {
                    PrecomputeAction.this.showClassificationResults();
                }
            }
        };
        this.getOWLModelManager().addListener(this.owlModelManagerListener);
    }

    private void showClassificationResults() {
        this.getOWLEditorKit().getWorkspace().getViewManager().bringViewToFront("org.protege.editor.owl.InferredOWLClassHierarchy");
        this.getOWLEditorKit().getWorkspace().getViewManager().bringViewToFront("org.protege.editor.owl.OWLInferredSuperClassHierarchy");
    }
}

