/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.inference;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class ReasonerProgressUI
implements ReasonerProgressMonitor {
    private static final Logger log = Logger.getLogger(ReasonerProgressUI.class);
    public static final long CLOSE_PROGRESS_TIMEOUT = 1000L;
    private OWLEditorKit owlEditorKit;
    private JLabel label;
    private JLabel taskLabel;
    private JProgressBar progressBar;
    private JDialog window;
    private boolean cancelled = false;
    private Action cancelledAction;
    private static final int CANCEL_TIMEOUT_MS = 5000;
    private boolean running = false;

    public ReasonerProgressUI(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        JPanel panel = new JPanel(new BorderLayout(7, 7));
        this.progressBar = new JProgressBar();
        panel.add((Component)this.progressBar, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.label = new JLabel("Classifying...");
        panel.add((Component)this.label, "North");
        this.taskLabel = new JLabel();
        panel.add((Component)this.taskLabel, "North");
        this.window = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)owlEditorKit.getWorkspace())), "Reasoner progress", true);
        this.cancelledAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ReasonerProgressUI.this.setCancelled();
            }
        };
        JButton cancelledButton = new JButton(this.cancelledAction);
        this.window.setLocation(400, 400);
        JPanel holderPanel = new JPanel(new BorderLayout(7, 7));
        holderPanel.add((Component)panel, "North");
        holderPanel.add((Component)cancelledButton, "East");
        holderPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add((Component)holderPanel, "North");
        this.window.pack();
        Dimension windowSize = this.window.getSize();
        this.window.setSize(400, windowSize.height);
        this.window.setResizable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelled() {
        ReasonerProgressUI reasonerProgressUI = this;
        synchronized (reasonerProgressUI) {
            this.cancelled = true;
            this.running = false;
        }
        this.owlEditorKit.getOWLModelManager().getOWLReasonerManager().killCurrentClassification();
        this.hideWindow();
    }

    public void reasonerTaskBusy() {
        this.progressBar.setIndeterminate(true);
    }

    public void reasonerTaskProgressChanged(int value, int max) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reasonerTaskStarted(String taskName) {
        ReasonerProgressUI reasonerProgressUI = this;
        synchronized (reasonerProgressUI) {
            this.running = true;
        }
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.showWindow();
        this.taskLabel.setText(taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reasonerTaskStopped() {
        ReasonerProgressUI reasonerProgressUI = this;
        synchronized (reasonerProgressUI) {
            this.running = false;
        }
        this.hideWindow();
        this.taskLabel.setText("");
    }

    private void showWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!ReasonerProgressUI.this.window.isVisible()) {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    ReasonerProgressUI.this.window.setLocation(screenSize.width / 2 - ReasonerProgressUI.this.window.getWidth() / 2, screenSize.height / 2 - ReasonerProgressUI.this.window.getHeight() / 2);
                    ReasonerProgressUI.this.window.setVisible(true);
                }
            }
        });
    }

    private void hideWindow() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean localCancelled;
                boolean localRunning;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"ow, ow, ow.  Don't prod me with that stick", (Throwable)e);
                }
                ReasonerProgressUI reasonerProgressUI = ReasonerProgressUI.this;
                synchronized (reasonerProgressUI) {
                    localRunning = ReasonerProgressUI.this.running;
                    localCancelled = ReasonerProgressUI.this.cancelled;
                }
                if (!localRunning) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (localCancelled) {
                                JOptionPane.showMessageDialog(ReasonerProgressUI.this.window, null, "Reasoning Task Cancelled", 1);
                            }
                            ReasonerProgressUI.this.window.setVisible(false);
                        }
                    });
                }
            }
        }.start();
    }
}

