/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.inference;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.ui.inference.InferencePreferencePlugin;
import org.protege.editor.owl.ui.inference.InferencePreferencePluginLoader;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class TabbedReasonerPreferencesPanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = 5167874018417496809L;
    public static final String LABEL = "Reasoner";
    private List<OWLPreferencesPanel> panels = new ArrayList<OWLPreferencesPanel>();

    public void initialise() throws Exception {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        InferencePreferencePluginLoader loader = new InferencePreferencePluginLoader(this.getOWLEditorKit());
        TreeSet<InferencePreferencePlugin> plugins = new TreeSet<InferencePreferencePlugin>(new Comparator<InferencePreferencePlugin>(){

            @Override
            public int compare(InferencePreferencePlugin o1, InferencePreferencePlugin o2) {
                String s1 = o1.getLabel();
                String s2 = o2.getLabel();
                return s1.compareTo(s2);
            }
        });
        plugins.addAll(loader.getPlugins());
        JScrollPane defaultComponent = null;
        for (InferencePreferencePlugin plugin : plugins) {
            try {
                OWLPreferencesPanel panel = plugin.newInstance();
                panel.initialise();
                String label = plugin.getLabel();
                JScrollPane scroller = new JScrollPane((Component)((Object)panel));
                scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.panels.add(panel);
                tabbedPane.addTab(label, scroller);
                if (!"Displayed Inferences".equals(label)) continue;
                defaultComponent = scroller;
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
        if (defaultComponent != null) {
            tabbedPane.setSelectedComponent(defaultComponent);
        }
        this.add(tabbedPane);
    }

    public void dispose() throws Exception {
        for (OWLPreferencesPanel panel : this.panels) {
            try {
                panel.dispose();
            }
            catch (Throwable t) {
                ProtegeApplication.getErrorLog().logError(t);
            }
        }
    }

    public void applyChanges() {
        for (OWLPreferencesPanel panel : this.panels) {
            try {
                panel.applyChanges();
            }
            catch (Throwable t) {
                ProtegeApplication.getErrorLog().logError(t);
            }
        }
    }
}

