/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.list;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.AnnotationContainer;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.editor.OWLAnnotationEditor;
import org.protege.editor.owl.ui.renderer.OWLAnnotationCellRenderer;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationsList<O extends AnnotationContainer>
extends MList {
    private static final long serialVersionUID = -2246627783362209148L;
    private static final String HEADER_TEXT = "Annotations";
    private OWLEditorKit eKit;
    private OWLAnnotationEditor editor;
    private O root;
    private MListSectionHeader header = new MListSectionHeader(){

        public String getName() {
            return AbstractAnnotationsList.HEADER_TEXT;
        }

        public boolean canAdd() {
            return true;
        }
    };
    private OWLOntologyChangeListener ontChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            AbstractAnnotationsList.this.handleOntologyChanges(changes);
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 2) {
                AbstractAnnotationsList.this.handleEdit();
            }
        }
    };
    private ListCellRenderer delegate;

    public AbstractAnnotationsList(OWLEditorKit eKit) {
        this.eKit = eKit;
        this.delegate = this.getCellRenderer();
        this.setCellRenderer(new OWLAnnotationCellRenderer(eKit){
            private static final long serialVersionUID = 3416003052933247552L;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof AnnotationsListItem) {
                    value = ((AnnotationsListItem)value).getAnnotation();
                    return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                }
                return AbstractAnnotationsList.this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.addMouseListener(this.mouseListener);
        eKit.getOWLModelManager().addOntologyChangeListener(this.ontChangeListener);
    }

    protected abstract List<OWLOntologyChange> getAddChanges(OWLAnnotation var1);

    protected abstract List<OWLOntologyChange> getReplaceChanges(OWLAnnotation var1, OWLAnnotation var2);

    protected abstract List<OWLOntologyChange> getDeleteChanges(OWLAnnotation var1);

    protected abstract void handleOntologyChanges(List<? extends OWLOntologyChange> var1);

    protected void handleAdd() {
        OWLAnnotation annot;
        if (this.editor == null) {
            this.editor = new OWLAnnotationEditor(this.eKit);
        }
        this.editor.setEditedObject(null);
        UIHelper uiHelper = new UIHelper(this.eKit);
        int ret = uiHelper.showValidatingDialog("Create Annotation", this.editor.getEditorComponent(), null);
        if (ret == 0 && (annot = this.editor.getEditedObject()) != null) {
            this.eKit.getModelManager().applyChanges(this.getAddChanges(annot));
        }
    }

    public void setRootObject(O root) {
        this.root = root;
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.header);
        if (root != null) {
            for (OWLAnnotation annot : root.getAnnotations()) {
                data.add(new AnnotationsListItem(annot));
            }
        }
        this.setListData(data.toArray());
        this.revalidate();
    }

    public O getRoot() {
        return this.root;
    }

    protected void refresh() {
        this.setRootObject(this.root);
    }

    protected void updateGlobalSelection(OWLObject owlObject) {
        this.eKit.getOWLWorkspace().getOWLSelectionModel().setSelectedObject(owlObject);
    }

    public void dispose() {
        this.eKit.getOWLModelManager().removeOntologyChangeListener(this.ontChangeListener);
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
    }

    public class AnnotationsListItem
    implements MListItem {
        private OWLAnnotation annot;

        public AnnotationsListItem(OWLAnnotation annot) {
            this.annot = annot;
        }

        public OWLAnnotation getAnnotation() {
            return this.annot;
        }

        public boolean isEditable() {
            return true;
        }

        public void handleEdit() {
            OWLAnnotation newAnnotation;
            if (AbstractAnnotationsList.this.editor == null) {
                AbstractAnnotationsList.this.editor = new OWLAnnotationEditor(AbstractAnnotationsList.this.eKit);
            }
            AbstractAnnotationsList.this.editor.setEditedObject(this.annot);
            UIHelper uiHelper = new UIHelper(AbstractAnnotationsList.this.eKit);
            int ret = uiHelper.showValidatingDialog("Ontology Annotation", AbstractAnnotationsList.this.editor.getEditorComponent(), null);
            if (ret == 0 && (newAnnotation = AbstractAnnotationsList.this.editor.getEditedObject()) != null && !newAnnotation.equals(this.annot)) {
                List<OWLOntologyChange> changes = AbstractAnnotationsList.this.getReplaceChanges(this.annot, newAnnotation);
                AbstractAnnotationsList.this.eKit.getModelManager().applyChanges(changes);
            }
        }

        public boolean isDeleteable() {
            return true;
        }

        public boolean handleDelete() {
            List<OWLOntologyChange> changes = AbstractAnnotationsList.this.getDeleteChanges(this.annot);
            AbstractAnnotationsList.this.eKit.getModelManager().applyChanges(changes);
            return true;
        }

        public String getTooltip() {
            return "";
        }
    }
}

