/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.list;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponent;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponentMediator;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLLinkedObjectList
extends OWLObjectList
implements LinkedObjectComponent {
    private LinkedObjectComponentMediator mediator;

    public OWLLinkedObjectList(OWLEditorKit owlEditorKit) {
        super(owlEditorKit);
        this.mediator = new LinkedObjectComponentMediator(owlEditorKit, this);
    }

    public Point getMouseCellLocation() {
        Point mouseLoc = this.getMousePosition();
        if (mouseLoc == null) {
            return null;
        }
        int index = this.locationToIndex(mouseLoc);
        Rectangle cellRect = this.getCellBounds(index, index);
        return new Point(mouseLoc.x - cellRect.x, mouseLoc.y - cellRect.y);
    }

    public Rectangle getMouseCellRect() {
        Point loc = this.getMousePosition();
        if (loc == null) {
            return null;
        }
        int index = this.locationToIndex(loc);
        return this.getCellBounds(index, index);
    }

    public void setLinkedObject(OWLObject object) {
        this.mediator.setLinkedObject(object);
    }

    public OWLObject getLinkedObject() {
        return this.mediator.getLinkedObject();
    }

    public JComponent getComponent() {
        return this;
    }
}

