/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.list;

import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRendererSimple;
import org.protege.editor.owl.ui.transfer.OWLObjectListDragGestureListener;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectList<O extends OWLObject>
extends JList {
    public OWLObjectList(OWLEditorKit owlEditorKit) {
        this.setCellRenderer(new OWLCellRendererSimple(owlEditorKit));
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this, 1, new OWLObjectListDragGestureListener(owlEditorKit, this));
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Object element;
        int index = this.locationToIndex(event.getPoint());
        if (index >= 0 && (element = this.getModel().getElementAt(index)) != null && element instanceof OWLEntity) {
            return ((OWLEntity)element).getIRI().toString();
        }
        return null;
    }

    public void setSelectedValues(Set<O> owlObjects, boolean shouldScroll) {
        this.getSelectionModel().clearSelection();
        if (this.getSelectionMode() == 2) {
            int firstIndex = -1;
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                if (!owlObjects.contains((OWLObject)this.getModel().getElementAt(i))) continue;
                this.getSelectionModel().addSelectionInterval(i, i);
                if (firstIndex != -1) continue;
                firstIndex = i;
            }
            if (shouldScroll && firstIndex != -1) {
                this.scrollRectToVisible(new Rectangle(this.getCellBounds(firstIndex, firstIndex)));
            }
        }
    }

    public List<O> getSelectedOWLObjects() {
        ArrayList<OWLObject> sel = new ArrayList<OWLObject>();
        for (Object o : this.getSelectedValues()) {
            sel.add((OWLObject)o);
        }
        return sel;
    }
}

