/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.metrics;

import java.awt.BorderLayout;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.metrics.DLNameKeyPanel;
import org.protege.editor.owl.ui.metrics.DLNamePanel;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.DLExpressivityChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLMetricsViewComponent
extends AbstractOWLViewComponent {
    private static final Logger logger = Logger.getLogger(DLMetricsViewComponent.class);
    private boolean changed;
    private OWLOntologyChangeListener listener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            DLMetricsViewComponent.this.handleChanges(changes);
        }
    };
    private OWLModelManagerListener modelManagerListener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_RELOADED)) {
                DLMetricsViewComponent.this.changed = true;
                DLMetricsViewComponent.this.refresh();
            }
        }
    };
    private HierarchyListener hierarchyListener = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent e) {
            DLMetricsViewComponent.this.changed = true;
            DLMetricsViewComponent.this.refresh();
        }
    };
    private DLNamePanel namePanel;

    @Override
    protected void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout());
        DLExpressivityChecker expressivityChecker = new DLExpressivityChecker(this.getOWLModelManager().getActiveOntologies());
        this.namePanel = new DLNamePanel();
        this.namePanel.setBorder(ComponentFactory.createTitledBorder((String)"DL Expressivity"));
        this.add(this.namePanel, "North");
        DLNameKeyPanel keyPanel = new DLNameKeyPanel();
        keyPanel.setBorder(ComponentFactory.createTitledBorder((String)"Symbol key"));
        this.add(keyPanel, "Center");
        this.setName();
        this.getOWLModelManager().addOntologyChangeListener(this.listener);
        this.getOWLModelManager().addListener(this.modelManagerListener);
        this.addHierarchyListener(this.hierarchyListener);
    }

    @Override
    protected void disposeOWLView() {
        this.getOWLModelManager().removeOntologyChangeListener(this.listener);
        this.getOWLModelManager().removeListener(this.modelManagerListener);
        this.removeHierarchyListener(this.hierarchyListener);
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !oWLOntologyChange.getAxiom().isLogicalAxiom()) continue;
            this.changed = true;
            this.refresh();
            break;
        }
    }

    private void setName() {
        try {
            DLExpressivityChecker checker = new DLExpressivityChecker(this.getOWLModelManager().getActiveOntologies());
            this.namePanel.setConstructs(checker.getConstructs());
        }
        catch (OWLException e) {
            logger.error((Object)e);
        }
    }

    private void refresh() {
        if (this.isShowing()) {
            if (this.changed) {
                this.setName();
                this.changed = false;
            }
        } else {
            this.changed = true;
        }
    }
}

