/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.metrics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.OWLAxiomTypeFramePanel;
import org.protege.editor.owl.ui.metrics.MetricsTableModel;
import org.semanticweb.owlapi.metrics.AxiomCountMetric;
import org.semanticweb.owlapi.metrics.AxiomTypeMetric;
import org.semanticweb.owlapi.metrics.DLExpressivity;
import org.semanticweb.owlapi.metrics.GCICount;
import org.semanticweb.owlapi.metrics.HiddenGCICount;
import org.semanticweb.owlapi.metrics.OWLMetric;
import org.semanticweb.owlapi.metrics.OWLMetricManager;
import org.semanticweb.owlapi.metrics.ReferencedClassCount;
import org.semanticweb.owlapi.metrics.ReferencedDataPropertyCount;
import org.semanticweb.owlapi.metrics.ReferencedIndividualCount;
import org.semanticweb.owlapi.metrics.ReferencedObjectPropertyCount;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class MetricsPanel
extends JPanel {
    private Map<String, OWLMetricManager> metricManagerMap;
    private Map<OWLMetricManager, MetricsTableModel> tableModelMap;
    private OWLEditorKit owlEditorKit;
    private JPopupMenu popupMenu;
    private AxiomCountMetric lastMetric;

    public MetricsPanel(OWLEditorKit editorKit) {
        this.owlEditorKit = editorKit;
        this.initialiseOWLView();
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new AbstractAction("Show axioms"){

            public void actionPerformed(ActionEvent e) {
                MetricsPanel.this.showAxiomTypeDialog();
            }
        });
    }

    private void showAxiomTypeDialog() {
        Set axioms = this.lastMetric.getAxioms();
        final OWLAxiomTypeFramePanel panel = new OWLAxiomTypeFramePanel(this.owlEditorKit);
        HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>(axioms);
        panel.setRoot(axs);
        panel.setPreferredSize(new Dimension(800, 300));
        JOptionPane op = new JOptionPane(panel, -1, 2);
        JDialog dlg = op.createDialog(this, this.lastMetric.getName());
        dlg.setResizable(true);
        dlg.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                panel.dispose();
            }
        });
        dlg.setModal(false);
        dlg.setVisible(true);
    }

    protected void initialiseOWLView() {
        this.metricManagerMap = new LinkedHashMap<String, OWLMetricManager>();
        this.tableModelMap = new HashMap<OWLMetricManager, MetricsTableModel>();
        this.createBasicMetrics();
        this.createClassAxiomMetrics();
        this.createObjectPropertyAxiomMetrics();
        this.createDataPropertyAxiomMetrics();
        this.createIndividualAxiomMetrics();
        this.createAnnotationAxiomMetrics();
        this.createUI();
        this.updateView(this.owlEditorKit.getModelManager().getActiveOntology());
        for (OWLMetricManager man : this.metricManagerMap.values()) {
            for (OWLMetric m : man.getMetrics()) {
                m.setImportsClosureUsed(true);
                m.setOntology(this.owlEditorKit.getModelManager().getActiveOntology());
            }
        }
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        Box box = new Box(1);
        for (String metricsSet : this.metricManagerMap.keySet()) {
            MetricsTableModel tableModel = new MetricsTableModel(this.metricManagerMap.get(metricsSet));
            this.tableModelMap.put(this.metricManagerMap.get(metricsSet), tableModel);
            final JTable table = new JTable(tableModel);
            table.setGridColor(Color.LIGHT_GRAY);
            table.setRowHeight(table.getRowHeight() + 4);
            table.setShowGrid(true);
            table.getColumnModel().getColumn(1).setMaxWidth(150);
            table.getColumnModel().setColumnMargin(2);
            table.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.handleTablePopupRequest(table, e);
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.handleTablePopupRequest(table, e);
                    }
                }

                private void handleTablePopupRequest(JTable table2, MouseEvent e) {
                    int row = table2.rowAtPoint(e.getPoint());
                    int col = table2.columnAtPoint(e.getPoint());
                    if (row == -1 || col == -1) {
                        return;
                    }
                    MetricsTableModel model = (MetricsTableModel)table2.getModel();
                    for (OWLMetricManager man : MetricsPanel.this.tableModelMap.keySet()) {
                        if (!((MetricsTableModel)MetricsPanel.this.tableModelMap.get(man)).equals(model)) continue;
                        OWLMetric metric = (OWLMetric)man.getMetrics().get(row);
                        if (!(metric instanceof AxiomCountMetric)) break;
                        MetricsPanel.this.lastMetric = (AxiomCountMetric)metric;
                        MetricsPanel.this.popupMenu.show(table2, e.getX(), e.getY());
                        break;
                    }
                }
            });
            final JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showMenu(e);
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showMenu(e);
                    }
                }

                private void showMenu(MouseEvent e) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new AbstractAction("Copy metrics to clipboard"){

                        public void actionPerformed(ActionEvent e) {
                            MetricsPanel.this.exportCSV();
                        }
                    });
                    menu.show(tablePanel, e.getX(), e.getY());
                }
            });
            tablePanel.add(table);
            tablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 14, 2), ComponentFactory.createTitledBorder((String)metricsSet)));
            table.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            box.add(tablePanel);
        }
        JScrollPane sp = new JScrollPane(box);
        sp.setOpaque(false);
        this.add(sp);
    }

    private void createBasicMetrics() {
        ArrayList<Object> metrics = new ArrayList<Object>();
        metrics.add(new ReferencedClassCount(this.getOWLModelManager().getOWLOntologyManager()));
        metrics.add(new ReferencedObjectPropertyCount(this.getOWLModelManager().getOWLOntologyManager()));
        metrics.add(new ReferencedDataPropertyCount(this.getOWLModelManager().getOWLOntologyManager()));
        metrics.add(new ReferencedIndividualCount(this.getOWLModelManager().getOWLOntologyManager()));
        metrics.add(new DLExpressivity(this.getOWLModelManager().getOWLOntologyManager()));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Metrics", metricManager);
    }

    private void createClassAxiomMetrics() {
        ArrayList<Object> metrics = new ArrayList<Object>();
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.SUBCLASS_OF));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.EQUIVALENT_CLASSES));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.DISJOINT_CLASSES));
        metrics.add(new GCICount(this.getOWLModelManager().getOWLOntologyManager()));
        metrics.add(new HiddenGCICount(this.getOWLModelManager().getOWLOntologyManager()));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Class axioms", metricManager);
    }

    private void createObjectPropertyAxiomMetrics() {
        ArrayList<AxiomTypeMetric> metrics = new ArrayList<AxiomTypeMetric>();
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.SUB_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.EQUIVALENT_OBJECT_PROPERTIES));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.INVERSE_OBJECT_PROPERTIES));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.DISJOINT_OBJECT_PROPERTIES));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.FUNCTIONAL_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.TRANSITIVE_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.SYMMETRIC_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.ASYMMETRIC_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.REFLEXIVE_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.IRREFLEXIVE_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.OBJECT_PROPERTY_DOMAIN));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.OBJECT_PROPERTY_RANGE));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.SUB_PROPERTY_CHAIN_OF));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Object property axioms", metricManager);
    }

    private void createDataPropertyAxiomMetrics() {
        ArrayList<AxiomTypeMetric> metrics = new ArrayList<AxiomTypeMetric>();
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.SUB_DATA_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.EQUIVALENT_DATA_PROPERTIES));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.DISJOINT_DATA_PROPERTIES));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.FUNCTIONAL_DATA_PROPERTY));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.DATA_PROPERTY_DOMAIN));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.DATA_PROPERTY_RANGE));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Data property axioms", metricManager);
    }

    private void createIndividualAxiomMetrics() {
        ArrayList<AxiomTypeMetric> metrics = new ArrayList<AxiomTypeMetric>();
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.CLASS_ASSERTION));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.OBJECT_PROPERTY_ASSERTION));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.DATA_PROPERTY_ASSERTION));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.SAME_INDIVIDUAL));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.DIFFERENT_INDIVIDUALS));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Individual axioms", metricManager);
    }

    private void createAnnotationAxiomMetrics() {
        ArrayList<AxiomTypeMetric> metrics = new ArrayList<AxiomTypeMetric>();
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.ANNOTATION_ASSERTION));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.ANNOTATION_PROPERTY_DOMAIN));
        metrics.add(new AxiomTypeMetric(this.getOWLModelManager().getOWLOntologyManager(), AxiomType.ANNOTATION_PROPERTY_RANGE));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Annotation axioms", metricManager);
    }

    public void updateView(OWLOntology activeOntology) {
        for (OWLMetricManager man : this.metricManagerMap.values()) {
            man.setOntology(activeOntology);
        }
        this.repaint();
    }

    private OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    private void exportCSV() {
        StringBuilder sb = new StringBuilder();
        for (OWLMetricManager man : this.metricManagerMap.values()) {
            sb.append(man.toString());
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(sb.toString()), null);
    }
}

