/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.navigation;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.navigation.OWLEntityNavigationMediator;

public class OWLEntityNavPanel
extends JPanel {
    private OWLEditorKit editorKit;
    private OWLEntityNavigationMediator mediator;
    private Action backAction;
    private Action forwardAction;

    public OWLEntityNavPanel(OWLEditorKit owlEditorKit) {
        this.editorKit = owlEditorKit;
        this.createActions();
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.backAction);
        toolBar.add(this.forwardAction);
        toolBar.setBorder(null);
        toolBar.setFloatable(false);
        toolBar.setBorderPainted(false);
        this.add(toolBar);
        this.mediator = new OWLEntityNavigationMediator(this.editorKit, this.backAction, this.forwardAction);
    }

    public void dispose() {
        this.mediator.dispose();
    }

    private void createActions() {
        this.backAction = new AbstractAction("Navigate back", OWLIcons.getIcon("nav.back.png")){

            public void actionPerformed(ActionEvent e) {
                OWLEntityNavPanel.this.editorKit.getWorkspace().getOWLSelectionHistoryManager().goBack();
                OWLEntityNavPanel.this.editorKit.getWorkspace().displayOWLEntity(OWLEntityNavPanel.this.editorKit.getWorkspace().getOWLSelectionModel().getSelectedEntity());
            }
        };
        KeyStroke backKS = KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(backKS, "nav-back");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("nav-back", this.backAction);
        this.forwardAction = new AbstractAction("Navigate forward", OWLIcons.getIcon("nav.fwd.png")){

            public void actionPerformed(ActionEvent e) {
                OWLEntityNavPanel.this.editorKit.getWorkspace().getOWLSelectionHistoryManager().goForward();
                OWLEntityNavPanel.this.editorKit.getWorkspace().displayOWLEntity(OWLEntityNavPanel.this.editorKit.getWorkspace().getOWLSelectionModel().getSelectedEntity());
            }
        };
        KeyStroke forwardKS = KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(forwardKS, "nav-forward");
        actionMap.put("nav-forward", this.forwardAction);
    }

    protected OWLModelManager getOWLModelManager() {
        return this.editorKit.getModelManager();
    }
}

