/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLOntology;

public class ActiveOntologyView
extends AbstractOWLViewComponent {
    private static final Logger logger = Logger.getLogger(ActiveOntologyView.class);
    private JComboBox ontologiesList;
    private OWLModelManagerListener owlModelManagerListener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
                ActiveOntologyView.this.ontologiesList.setSelectedItem(ActiveOntologyView.this.getOWLModelManager().getActiveOntology());
            }
        }
    };

    public void disposeOWLView() {
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
    }

    public void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout());
        this.ontologiesList = new JComboBox();
        this.ontologiesList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OWLOntology ont = (OWLOntology)ActiveOntologyView.this.ontologiesList.getSelectedItem();
                if (ont != null) {
                    ActiveOntologyView.this.getOWLModelManager().setActiveOntology(ont);
                }
            }
        });
        this.add(this.ontologiesList);
        this.getOWLModelManager().addListener(this.owlModelManagerListener);
        this.rebuildList();
    }

    private void rebuildList() {
        try {
            this.ontologiesList.setModel(new DefaultComboBoxModel<Object>(this.getOWLModelManager().getOntologies().toArray()));
            this.ontologiesList.setSelectedItem(this.getOWLModelManager().getActiveOntology());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

