/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import java.net.URI;
import java.util.Calendar;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class OntologyPreferences {
    public static final String DEFAULT_BASE = "http://www.semanticweb.org/ontologies";
    public static final String PREFERENCES_KEY = "OntologyPreferences";
    public static final String BASE_URI_KEY = "BASE_URI";
    public static final String INC_YEAR_KEY = "INC_YEAR";
    public static final String INC_MONTH_KEY = "INC_MONTH";
    public static final String INC_DAY_KEY = "INC_DAY";
    private static OntologyPreferences instance;
    private URI baseURI = URI.create("http://www.semanticweb.org/ontologies");
    private boolean includeYear = true;
    private boolean includeMonth = true;
    private boolean includeDay = false;

    private OntologyPreferences() {
    }

    public static synchronized OntologyPreferences getInstance() {
        if (instance == null) {
            instance = new OntologyPreferences();
            instance.restore();
        }
        return instance;
    }

    private void restore() {
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences(PREFERENCES_KEY);
        this.baseURI = URI.create(p.getString(BASE_URI_KEY, DEFAULT_BASE));
        this.includeYear = p.getBoolean(INC_YEAR_KEY, true);
        this.includeMonth = p.getBoolean(INC_MONTH_KEY, true);
        this.includeDay = p.getBoolean(INC_DAY_KEY, false);
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
        this.save();
    }

    public boolean isIncludeYear() {
        return this.includeYear;
    }

    public void setIncludeYear(boolean includeYear) {
        this.includeYear = includeYear;
        this.save();
    }

    public boolean isIncludeMonth() {
        return this.includeMonth;
    }

    public void setIncludeMonth(boolean includeMonth) {
        this.includeMonth = includeMonth;
        this.save();
    }

    public boolean isIncludeDay() {
        return this.includeDay;
    }

    public void setIncludeDay(boolean includeDay) {
        this.includeDay = includeDay;
        this.save();
    }

    private void save() {
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences(PREFERENCES_KEY);
        p.putString(BASE_URI_KEY, this.baseURI.toString());
        p.putBoolean(INC_YEAR_KEY, this.includeYear);
        p.putBoolean(INC_MONTH_KEY, this.includeMonth);
        p.putBoolean(INC_DAY_KEY, this.includeDay);
    }

    public URI generateURI() {
        String uriString = this.baseURI.toString();
        if (!uriString.endsWith("/")) {
            uriString = uriString + "/";
        }
        if (this.includeYear) {
            uriString = uriString + Calendar.getInstance().get(1) + "/";
            if (this.includeMonth) {
                uriString = uriString + Calendar.getInstance().get(2) + "/";
                if (this.includeDay) {
                    uriString = uriString + Calendar.getInstance().get(5) + "/";
                }
            }
        }
        String name = "Ontology" + System.currentTimeMillis() + ".owl";
        uriString = uriString + name;
        return URI.create(uriString);
    }
}

